/**
 * jQuery Plugins for Shopware 3.5 Storefront
 * http://shopware.de
 *
 *
 * DISCLAIMER
 *
 * Do not edit this file if you wish to upgrade
 * Shopware to newer versions in the future. If
 * you wish to customize Shopware for your needs
 * please refer to http://www.shopware.de/wiki
 * for more informations.
 *
 * @package		default
 * @subpackage	javascript
 * @category	design
 * version		v1.9
 * @author		stp/shopware AG <info@shopware.de>
 * @copyright	Copyright (c) 2010 Shopware AG (http://www.shopware.de)
 *
 * CHANGELOG
 * Version 1.9
 * - removed unnecessary CSS styling
 *
 * Version 1.8
 * - added ajax slider component
 * - loading indicator plugin
 *
 * Version 1.7
 * - added OnePage checkout
 * - liveshopping plugin
 * - check notifcation
 * - bundle plugin
 * - refactoring livesearch
 *
 * Version 1.6
 * - added modal window plugin
 * - added ajax basket plugin
 * - onepage checkout
 * - compressed plugins
 *
 * Version 1.5
 * - inital release
 * - changing listing view
 * - replace fancybox with an enhanced version of slimbox
 * - replace jqzoom with an enhanced version of cloudzoom
 * - completely rewritten topseller accordion
 * - added slideable properties filters
 * - serveral improvements
 * - added jquery ui and jquery tabs
 *
 * Version 1.4
 * - bugfix release
 * - added cross-browser support
 *
 * Version 1.3
 * - added utilities, fancybox and jqzoom
 * - fixes serval bugs in the compare plugin
 *
 * Version 1.2
 * - added search and compare
 *
 * Version 1.1
 * - bugfix release
 *
 * Version 1.0
 * - inital release
 */
jQuery(document).ready(function($) {

		// Removes hiding class for all script related elements
		$('.hide_script').removeClass('hide_script');
		
		//IE 6 Drop down menu fallback
		if($.browser.msie === true && parseInt($.browser.version, 10) == 6) {
			$('#mainNavigation li').hover(function(){ $(this).addClass('hover'); }, function() { $(this).removeClass('hover'); });
		}
		
		//Liveshopping 
		$('.liveshopping_container:visible, .liveshopping_detail:visible').liveshopping();
		
		//Bundle
		$('.bundle_container, .relatedbox_container').bundle();
			
		//Checkout
		$('a.checkout, a.login, a.account').checkout({'viewport': $.controller.ajax_login,'register':$.controller.register,'checkout':$.controller.checkout});
				 
		//Supplier filter
		$('.supplier_filter .slideContainer').supplierfilter();
		
		//AJAX Warenkorb
		$.basket.options.viewport = $.controller.ajax_cart;$.basket.init();
		
		$('select.auto_submit').bind('change', function() {this.form.submit(); });
		$('input.auto_submit:radio, a.auto_submit, input.auto_submit:checkbox').live('click', function() { this.form.submit(); });
		$('input.auto_submit:text').live('blur', function() { this.form.submit(); });
		
		$('.modal_close').live('click', function() { $.modalClose(); $.ie6fix.selectShow(); });
		
		$('.modal_open a').click(function(event) {
			event.preventDefault();
			$.post(this.href, function(data) {
				$.modal(data, '', {'position':'fixed'}).find('.close').remove();			
			});
		});
				
		//Topseller
		if($('.topseller')) { $('.accordion').kwicks({min: 52,sticky: true,spacing: 0,isVertical: true,duration: 350}); }
		
		//Suggest Search
		$('#searchfield').liveSearch({url:$.controller.ajax_search, 'id': 'searchresults'});
		var defaultValue = $('#searchfield').val();
		$('#searchfield').focus(function(){
			if ($('#searchfield').val() == defaultValue){
				$('#searchfield').val('');
			}
		});
		
		//Get's the servertime for liveshopping articles
		$.server.init(timeNow);
		
		//Changing article informations on variants
		if(typeof(isVariant) != 'undefined' && isVariant === true) {
			$.changeDetails(0);
		}	
		$('#sAdd.variant').change(function() {
			$.changeDetails($(this).val());
		});
		
		//Lightbox basket
		$('a.zoom_picture[rel^=lightbox]').slimbox();
		
		//AJAX basket
		$('div.ajax_basket').click(function() {
			if($('.ajax_basket_result').hasClass('active')) {
				$('.ajax_basket_result').removeClass('active').slideToggle('fast');
			} else {
				$.basket.getBasket();
			}
		});
		
		//Article detail accessory
		var lasthover;
		$('.basketform label').hover(function() {
			var $this = $(this);
			
			var value = $this.prev('input').val();
			
			if(value.length) {
				$('div#DIV'+value).fadeIn('fast');
				lasthover = $('div#DIV'+value);
			}
		}, function() {
			lasthover.fadeOut('fast');
			lasthover = '';
		});
		
		//Article detail accessory
		$('.accessory_group input').bind('change', function() {
			var $this = $(this);
			$accessories = $('#sAddAccessories');
			$accessories.val('');
			if($this.is(':checked')) {
				
				$('.accessory_group input:checked').each(function(i, el) {
					var val = $accessories.val();
					val += $(el).val() + ';';
					$accessories.val(val);
				});
			}
		});
						
		//Lightbox - Blog
		$('.blogbox [rel^=lightbox]').slimbox();
		
		//Use a lightbox instead of a zoom
		if(typeof (useZoom) !== 'undefined' && (useZoom === '0' || useZoom === '')) {
			$("[rel^='lightbox']").slimbox();
			$('div.thumb_box a').bind('click', function(event) {
				event.preventDefault();
				$('a#zoom1').hide().attr('href', $(this).attr('href')).children().attr('src', $(this).attr('rev'));
				$('a#zoom1').fadeIn('slow');
				return false;
			});
		}

		$('.account .password').hide();
		$('.account .email').hide();
		
		//Change password account
		if($('.account .password').hasClass('displayblock')) {
			$('.account .password').show();
		}
		if($('.account .email').hasClass('displayblock')) {
			$('.account .password').show();
		}

		$('.account .change_password').bind('click', function(event) {
			event.preventDefault();
			$('.account .password').slideToggle('fast').toggleClass('active');
			$('.account .email').slideUp('fast');
		});
		
		//Change email account
		$('.account .change_mail').bind('click', function(event) {
			event.preventDefault();
			$('.account .email').slideToggle('fast').toggleClass('active');
			$('.account .password').slideUp('fast');
		});
		
		//Logout Account
		$('.logout').bind('click', function(event) {
			event.preventDefault();
			$.post($.controller.ajax_logout, function(data) {
				var position = 'fixed';
				if($.browser.msie && parseInt($.browser.version, 10) == 6) {
					position = 'absolute';
				}
				$.modal(data, '', {'position':position}).find('.close').remove();
				if($.browser.msie && ~~$.browser.version <= 7) {
					buttons = $('.modal').find('.button-right');
					buttons.each(function() {
						this.fireEvent('onmove');
					});
				}
			});
		});
		
		//User account page orders
		$('.orderoverview_active .orderdetails').bind('click', function(e) {
			e.preventDefault();
			if($('#'+$(this).attr('rel')).hasClass('active')) {
				$('#'+$(this).attr('rel')).removeClass('active').hide();
			} else {
				$('#'+$(this).attr('rel')).addClass('active').show();
			}
		});	
		
		//Register validation
		$('.register .required:input').validate();
		
		if($("#register_personal_customer_type").val()=="private") {
			$('.register .company_informations').hide();
		}
		
		if($("#register_personal_skipLogin").is(':checked')) {
			$('.register .fade_password, .register p.description, #birthdate').hide();
		}
		
		$("#register_personal_customer_type").change(function() {
			if($(this).val() == 'business') {
				$('.register .company_informations').slideDown();
			} else {
				$('.register .company_informations').slideUp();
			}
		});
		
		if(!$("#register_billing_shippingAddress").is(':checked')) {
			if(!$('.register').hasClass('change_shipping')) {
				$('.register .alternative_shipping').hide();
			}
		}
		
		$('#register_billing_shippingAddress').click(function() {
			if(!$(this).is(':checked')) {
				$('.register .alternative_shipping').slideUp();
			} else {
				$('.register .alternative_shipping').slideDown();
			}
		});
		
		$('#register_personal_skipLogin').click(function() {
			if($(this).is(':checked')) {
				$('.register .fade_password, .register p.description, #birthdate').slideUp();
			} else {
				$('.register .fade_password, .register p.description, #birthdate').slideDown();
			}
		});
		
		// Loading Indicator
		$('form.upprice_config').bind('change', function() {
			$.loadingIndicator.open();
		});

});

/**
 * AJAX Validation
 * for Shopware
 *
 * Shopware AG (c) 2011
 */

/**
 * AJAX Validation
 * for Shopware
 *
 * Shopware AG (c) 2011
 */
(function($) {

	/** Plugin starter */
	$(document).ready(function() {
		$('.account .password :input').accountValidation();
		$('.account .email input').accountValidation();
	});

	/**
	 * Shopware UI - Account validation
	 *
	 * This jQuery plugin checks the given
	 * mail address and the given password
	 * against our criterions. Additionally we're
	 * checking the mail address against the server side
	 * to avoid account hijacking
	 *
	 * Example usage:
	 * $('[selector]').accountValidation([settings]);
	 *
	 * @param {obj} settings - user settings
	 * @return {obj} jQuery object basend on the given selector
	 */
	$.fn.accountValidation = function(settings) {

		/** Extend the default configuration with the provided user settings */
		if(settings) $.extend($.accountValidation.config, settings);

		/** Return this for jQuery's chaining support */
		return this.each(function() {
			var $me = $(this);

			/** Disable the submit button */
			if(!$.browser.msie && parseInt($.browser.version) != 6) {
				$me.parents('form').find('input[type=submit]').attr('disabled', 'disabled').css('opacity', 0.5);
			}

			/** Event listener which checks on every keystroke the password and it's iteration */
			$me.bind('keyup', function() {
				if($me.attr('id') == 'newpwdrepeat' && $me.val().length == $('#newpwd').val().length) {
					$me.triggerHandler('blur');
				}
				if($me.attr('id') == 'newmailrepeat' && $me.val().length == $('#newmail').val().length) {
					$me.triggerHandler('blur');
				}
			});

			/** Event listener which checks the given mail addresses or the given password against the server side */
			$me.bind('blur', function() {
				var error = false;

				if(!$me.val().length) { error = true; }

				if(($me.attr('id') == 'newpwd' || $me.attr('id') == 'newpwdrepeat') && !error) {
					$.accountValidation.checkPasswd($me);
				}

				if(($me.attr('id') == 'neweailrepeat' || $me.attr('id') == 'newmail') && !error) {
					$.accountValidation.checkEmail($me);
				}
			});
		});
	};

	$.accountValidation = {

		/** Default configuration */
		config: {
			errorCls: 'instyle_error',
			successCls: 'instyle_success'
		},

		/**
		 * Simple method which sets the configured error class to the given element
		 *
		 * @param {obj} $el - jQuery object of the element which will become invalid
		 * @return {obj} $el - jQuery object of the passed element
		 */
		setError: function($el) {
			$el.removeClass($.accountValidation.config.successCls).addClass($.accountValidation.config.errorCls);

			return $el;
		},

		/**
		 * Simple method which sets the configured success class to the given element
		 *
		 * @param {obj} $el - jQuery object of the element which will become valid
		 * @return {obj} $el - jQuery object of the passed element
		 */
		setSuccess: function($el) {
			$el.removeClass($.accountValidation.config.errorCls).addClass($.accountValidation.config.successCls);

			return $el;
		},

		/**
		 * Validates the password
		 *
		 * @param {obj} object of the repeat field
		 * @return void
		 */
		checkPasswd: function($repeat) {
			var $form = $repeat.parents('form');

			var str = '';

			$form.find('input[type=password]').each(function(i, el) {
				var $el = $(el), name = $el.attr('name');

				if(str.length) { str += '&'; }
				str += 'register[personal][' + name + ']='+$el.val();
			});

			str = encodeURI(str);

			$.accountValidation.ajaxValidation('ajax_validate_password', str, $form);
		},

		/**
		 * Validates the email address
		 *
		 * @param {obj} object of the repeat field
		 * @return void
		 */
		checkEmail: function($repeat) {
			var $form = $repeat.parents('form');

			var str = '';
			$form.find('input[type=text]').each(function(i, el) {
				var $el = $(el), name = $el.attr('name');

				if(str.length) { str += '&'; }
				str += 'register[personal][' + name + ']='+$el.val();
			});

			str = encodeURI(str);

			$.accountValidation.ajaxValidation('ajax_validate_email', str, $form);
		},

		/**
		 * Validates the given elements against the server side
		 * and determines on the base of the request response
		 * if the given elements are valid or invalid.
		 *
		 * @param {str} action - the action which will be called server side
		 * @param {str} data - the data string which will be send to the server
		 * @param {obj} $form - jQuery object of the form
		 * @return void
		 */
		ajaxValidation: function(action, data, $form) {

			$.ajax({
				'data': 'action=' + action + '&' + data,
				'type': 'post',
				'dataType': 'json',
				'url': $.controller.ajax_validate,
				'success': function(result) {

					$.each(result.error_flags, function(key, val) {
						if(val) {
							$.accountValidation.setError($('input[name=' + key + ']'));
						} else {
							$.accountValidation.setSuccess($('input[name=' + key + ']'));
						}
					});

					if(!result.success) {

						if(!$.isEmptyObject(result.error_flags)) {

							$(document.body).find('#ajax-validate-error').remove();

							// Get first element in form
							var first = $form.find('input:first');

							// Output error message
							var err = $('<div>', {
								'class': 'error',
								'id': 'ajax-validate-error',
								'html': result.error_messages[0],
								'css': {
									'display': 'none',
									'position': 'absolute',
									'top': first.offset().top,
									'left': first.offset().left + first.outerWidth() + 30,
									'width': 200,
									'zIndex': 100
								}
							}).prependTo($(document.body)).fadeIn('fast');

							window.setTimeout(function() {
								err.remove();
							}, 4000);

							// Check for IE6 to prevent a displaying issue
							if(!$.browser.msie && parseInt($.browser.version) != 6) {
								$form.find(':submit').attr('disabled', 'disabled').css('opacity', 0.5);
							}
						}
					}  else {

						$form.find('input[type=password], input[type=text]').each(function(i, el) {
							$(document.body).find('#ajax-validate-error').remove();

							// Check for IE6 to prevent a displaying issue
							if(!$.browser.msie && parseInt($.browser.version) != 6) {

								$form.find('input[type=submit]').removeAttr('disabled').css('opacity', 1);
							}
						});
					}
				}
			});
		}
	};
})(jQuery);

/**
 * AJAX Slider
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function($) {
		
	/**
	 * $.fn.ajaxSlider
	 *
	 * Creates an slider
	 *
	 * Just call the plugin with the following syntax:
	 * $('selector').ajaxSlider('[mode]', { [your_settings] });
	 *
	 * The called file must have the following structure
	 * <div class="slide">
	 *     ... [your elements] ...
	 * </div>
	 *
	 * If you're calling this plugin in ajax mode, please
	 * consider that this plugin has two kinds of ajax mode.
	 *
	 * You're getting in the first mode if you're setting
	 * the mode to 'ajax' and 'navigation': true. This mode get's
	 * all data at the page load and scrolls through the slides.
	 * The second modes would be called when you set the mode to
	 * 'ajax' and 'navigation': false.  
	 *
	 * @param:  (string) mode  - mode to use
	 * @param:  (obj) settings - user settings
	 * @return: (obj) this     - selector which was passed to the plugin
	 */
	$.fn.ajaxSlider = function(mode, settings) {
		
		// default plugin config
		var config = {
			
			// Public
			'layout':           'horizontal',
			'scrollWidth':      711,
			'scrollHeight':     711,
			'scrollSpeed':      400,
			'containerClass':   'ajaxSlider',
			'containerCSS':     {},
			'ajaxMethod':       'POST',
			'loadingText':      'Loading...',
			'loadingContainer': 'loader',
			'title':            '',
			'titleClass':       'headingbox',
			'headline':         false,
			'url':              '',
			'rotate':           false,
			'rotateSpeed':      5000,
			'navigation':       true,
			'navigationClass':  'slide_navigation',
			'showNumbers':      true,
			'numberText':       'Seite %0 von %1',
			'debug':            false,
			
			// Private
			'_this':                 null,
			'_container':            null,
			'_slideContainer':       null,
			'_slideOuterContainer':  null,
			'_slideContainerWidth':  null,
			'_slideContainerHeight': null,
			'_headline':             null,
			'_loader':               null,
			'_leftArrow':            null,
			'_rightArrow':           null,
			'_slidesCount':          null,
			'_slideNavigation':      null,
			'_activeNavigation':     null,
			'_activeSlide':          null,
			'_rotateInterval':       null,
			'_numbers':              null,
			'_mode':			     null
		};
		
		// Override default config with user settings
		if (settings) { $.extend(config, settings); }
		
		this.each(function() {
			
			if(config.debug === true) {
				console.group('Slider: .' + $(this).attr('class'));
			}
			
			$.ajaxSlider.debugMode('Mode: ' + mode, config);
			
			config._this = $(this);
			
			$.ajaxSlider.debugMode('Create Container', config);
			
			// Create slider outer container and replace selector
			config._container = $('<div>', {
				'class': config.containerClass
			}).appendTo(config._this);
			
			$.ajaxSlider.debugMode('Container created', config);
			
			// Save slider mode
			config._mode = mode;
			
			// Add layout class
			config._this.addClass(config.layout+'_slider');
			
			if(config.title !== '' && config.headline) {
				$.ajaxSlider.debugMode('Create headline', config);
				
				// Create headline
				config._headline = $('<h2>', {
					'class': config.titleClass,
					'text': config.title
				}).prependTo(config._container);
			}
			
			$.ajaxSlider.debugMode('Create left arrow', config);
			
			// Left arrow
			config._leftArrow = $('<a>', {
				'class': 'leftArrow',
				'text': 'Slide left',
				'title': 'Slide left',
				'href': '#slideLeft'
				}).appendTo(config._container).hide();
			
			$.ajaxSlider.debugMode('Create right arrow', config);
			
			// Right arrow
			config._rightArrow = $('<a>', {
				'class': 'rightArrow',
				'text': 'Slide right',
				'title': 'Slide right',
				'href': '#slideRight'
			}).appendTo(config._container).hide();
			
			
			$.ajaxSlider.debugMode('Select mode', config);
			
			// Mode selection
			switch(mode) {
				case 'ajax':
					$.ajaxSlider.ajaxMode(config);
					break;
				case 'locale':
					$.ajaxSlider.localeMode(config);
					break;
				default:
					$.ajaxSlider.debugMode('The passed mode is not supported', config);
					return false;
			}
			
			if(config.rotate === true) {
				$.ajaxSlider.debugMode('Create rotation', config);
				$.ajaxSlider.rotateSlider(config);
			}
		});
		
		if(config.debug === true) {
			console.groupEnd();
		}
		
		// Return this to support jQuery's chaining
		return this;
		};
		
		$.ajaxSlider = {
		
		/**
		 * $.ajaxSlider.createContainers
		 *
		 * Creates the needed container for the slider
		 *
		 * @param:  (obj) config - the plugin config
		 */
		createContainers: function(config) {
			// Create sliding outer container
			config._slideOuterContainer = $('<div>', {
				'class': 'sliding_outer'
			}).appendTo(config._container);
			
			// Create actual sliding container
			config._slideContainer = $('<div>', {
				'class': 'sliding_container'
			}).prependTo(config._slideOuterContainer).hide();
		},
		
		/**
		 * $.ajaxSlider.getPage
		 *
		 * Requests the given url
		 * and handles all ajax related
		 * stuff
		 *
		 * @param:  (string) slideNumber - Number of the slide to load
		 * @param:  (obj) config - the plugin config
		 */
		getPage: function(slideNumber, config) {
			$.ajax({
				'url': config.url,
				'method': config.ajaxMethod,
				'data': {'pages': slideNumber},
				'beforeSend': function() {
					if(config._loader === null) {
					
						// Create AJAX Loader
						config._loader = $('<div>', {
							'text': config.loadingText,
							'class': config.loadingContainer
						}).appendTo(config._container);
					} else {
						config._loader.show();
					}
					
					// Find old slide and remove it
					config._slideContainer.fadeOut().find('.slide').remove();
				},
				'error': function() {
					// Fadeout loader and hide container on error
					config._loader.fadeOut('slow');
					config._container.hide();
				},
				'success': function(result) {
					if(!result.length) {
						// If the result is empty, hide container
						config._loader.fadeOut('slow');
						config._container.hide();
						return false;
					} else {
						
						// Calculate where the content should be insert
						if(slideNumber > config._activeSlide) {
							$(result).appendTo(config._slideContainer);
						} else if(slideNumber < config._activeSlide) {
							$(result).prependTo(config._slideContainer);
						} else if(slideNumber == config._activeSlide) {
							config._slideContainer.html(result);
						}
						
						// Remove pages tag
						var pages = config._slideContainer.find('.pages');
						config._slidesCount = pages.text();
						pages.remove();
						
						//Handling arrows
						if(slideNumber == 1) {
							config._leftArrow.hide();
							config._rightArrow.show();
						} else if(slideNumber == config._slidesCount) {
							config._leftArrow.show();
							config._rightArrow.hide();
						} else {
							config._leftArrow.show();
							config._rightArrow.show();
						}
						
						if(parseInt(config._slidesCount, 10) === 1) {
							config._leftArrow.hide();
							config._rightArrow.hide();
						}
						
						if(parseInt(config._slidesCount, 10) === 0) {
							config._container.hide();
							return;
						}
						
						// horizontal slider
						if(config.layout == 'horizontal') {
							var height;
							if(!config.headline) {
								height = config.height;
							} else {
								height = config.height - config._headline.outerHeight();
							}
						// vertical slider
						} else {
							
							if(config.outer) {
								// Setting offset
								config._slideOuterContainer.css({
									'top': config._leftArrow.outerHeight()+'px',
									'height': config.height - config._headline.outerHeight() - (config._rightArrow.outerHeight() * 2)+'px'
								});
							} else {
								config._slideOuterContainer.css({
									'left': 0,
									'top': config._leftArrow.outerHeight()+'px',
									'height': config.height - config._headline.outerHeight()+'px'
								});
							}
		
						}
						
						// Adding numbers
						if(config.showNumbers === true) {
							if(config._numbers === null) { 
								config._numbers = $('<div>', {
									'class': 'slide_numbers'
								}).insertAfter(config._headline);
							}
							
							var text = $.format(config.numberText, slideNumber, config._slidesCount);
							config._numbers.empty().html(text);
						}
						
						
						config._activeSlide = slideNumber;
						
						config._loader.fadeOut('fast');
						config._slideContainer.fadeIn('slow');
						
						
						return true;
					}
				}
			});
		},
		
		/**
		 * $.ajaxSlider.ajaxMode
		 *
		 * Requests the given url
		 * and creates the needed container
		 *
		 * @param:  (obj) config - the plugin config
		 */
		ajaxMode: function(config) {
			
			if(config.navigation === false) {
				$.ajaxSlider.createContainers(config);
				config._activeSlide = 1;
				$.ajaxSlider.getPage(config._activeSlide, config);
				
				config._rightArrow.bind('click', function(event) {
					event.preventDefault();
					$.ajaxSlider.getPage(config._activeSlide + 1, config);
					
					
				});
				config._leftArrow.bind('click', function(event) {
					event.preventDefault();
					$.ajaxSlider.getPage(config._activeSlide - 1, config);
					
				});
		
				
			} else { 
				
				// Load content with ajax
				if(config.url.length) {
					$.ajax({
						'url': config.url,
						'method': config.ajaxMethod,
						'beforeSend': function() {
						
							// Create AJAX Loader
							config._loader = $('<div>', {
								'text': config.loadingText,
								'class': config.loadingContainer
							}).appendTo(config._container);
						},
						'error': function() {
							// Fadeout loader and hide container on error
							config._loader.fadeOut('slow');
							config._container.hide();
						},
						'success': function(result) {
							
							// If the result is empty, hide container
							if(!result.length) {
								config._loader.fadeOut('slow');
								config._container.hide();
								return;
							}
							
							// Hide AJAX loader
							window.setTimeout(function() {
								config._loader.fadeOut('slow');
								config._loader = null;
								
								
								// Create the needed containers
								$.ajaxSlider.createContainers(config);
								
								//Fill the container and fade it in
								config._slideContainer.html(result).fadeIn();
								
								$.ajaxSlider.sliderNavigation(config);
								
								// Configure the slider for both types
								if(config.layout == 'horizontal') {
									$.ajaxSlider.horizontalSlider(config);
								} else {
									$.ajaxSlider.verticalSlider(config);
								}
								
							}, 800);		
						}
					});
				} else {
					// Hide container if no url is passed
					config._container.hide();
				}
			}
		},
		
		/**
		 * $.ajaxSlider.localeMode
		 *
		 * Gets the given slides, creates the needed
		 * container and places the slides in it
		 * 
		 * @param:  (obj) config - the plugin config
		 */
		localeMode: function(config) {
			
			// Getting inline slides
			var slides = $(config._this).find('.slide');
			
			// Create sliding outer container
			config._slideOuterContainer = $('<div>', {
				'class': 'sliding_outer'
			}).appendTo(config._container);
			
			// Create actual sliding container
			config._slideContainer = $('<div>', {
				'class': 'sliding_container',
				'html': slides
			}).prependTo(config._slideOuterContainer).hide().fadeIn();
			
			// Configure the slider for both types
			if(config.layout == 'horizontal') {
				$.ajaxSlider.horizontalSlider(config);
			} else {
				$.ajaxSlider.verticalSlider(config);
			}
			
			// Create slider navigation
			if(config.navigation === true) {
				$.ajaxSlider.sliderNavigation(config);
			}
		
		},
		
		/**
		 * $.ajaxSlider.horizontalSlider
		 *
		 * Styles and creates all neeeded
		 * components for a horizontal slider
		 *
		 * @param:  (obj) config - the plugin config
		 */
		horizontalSlider: function(config) {
			var height;
			if(!config.headline) {
				height = config.height;
			} else {
				height = config.height - config._headline.outerHeight();
			}
			
			
			if(config.navigation === true || config.navigation === false && config._mode == 'locale') {
				
				// Setting the width of the slide container
				var slides = config._slideContainer.find('.slide');
				config._slideContainerWidth = 0;
				
				$.each(slides,function(i, el) { config._slideContainerWidth += $(el).width();});
				config._slideContainer.width(config._slideContainerWidth);
				
				// Getting the number of slides
				config._slidesCount = slides.length;
				
				// Show right arrow
				if(config._slidesCount > 1) {
					config._rightArrow.show();
				}
				
				// Right arrow
				config._rightArrow.bind('click', function(event) {
					$.ajaxSlider.rightArrow(event, config);
				});
				
				// Left arrow
				config._leftArrow.bind('click', function(event) {
					$.ajaxSlider.leftArrow(event, config);
				});
			}
		},
		
		/**
		 * $.ajaxSlider.verticalSlider
		 *
		 * Styles and creates all neeeded
		 * components for a vertical slider
		 *
		 * @param:  (obj) config - the plugin config
		 */
		verticalSlider: function(config) {
		
			// Position arrows
			config._leftArrow.css({
				'top': config._headline.outerHeight()
			});
			config._rightArrow.css({
				'top': config.height-config._rightArrow.outerHeight()
			});
			
			if(config.outer) {
				// Setting offset
				config._slideOuterContainer.css({
					'top': config._leftArrow.outerHeight()+'px',
					'height': config.height - config._headline.outerHeight() - (config._rightArrow.outerHeight() * 2)+'px'
				});
			} else {
				config._slideOuterContainer.css({
					'left': 0,
					'top': config._leftArrow.outerHeight()+'px',
					'height': config.height - config._headline.outerHeight()+'px'
				});
			}
			
			if(config.navigation === true) {
				// Setting containerHeight
				var slides = config._slideContainer.find('.slide');
				config._slideContainerHeight = 0;
				
				$.each(slides,function(i, el) {
					config._slideContainerHeight += $(el).height();
				});
				config._slideContainer.height(config._slideContainerWidth);
				
				// Getting the number of slides
				config._slidesCount = slides.length;
				
				// Binding events
				config._activeSlide = 1;
				
				// Show bottom arrow
				if(config._slidesCount > 1) {
					config._rightArrow.show();
				}
				
				// Right arrow
				config._rightArrow.bind('click', function(event) {
					$.ajaxSlider.rightArrow(event, config);
				});
				
				// Left arrow
				config._leftArrow.bind('click', function(event) {
					$.ajaxSlider.leftArrow(event, config);
				});
			}
		},

		
		rightArrow: function(event, config) {
			event.preventDefault();
					
			config._activeSlide++;
			clearInterval(config._rotateInterval);
			$.ajaxSlider.animateContainerTo(config._activeSlide, config);
		},
		
		leftArrow: function(event, config) {
			event.preventDefault();
			config._activeSlide--;
			window.clearInterval(config._rotateInterval);
			$.ajaxSlider.animateContainerTo(config._activeSlide, config);

		},
		
		/**
		 * $.ajaxSlider.sliderNavigation
		 *
		 * Styles and creates all neeeded
		 * components for a slider navigation
		 *
		 * @param:  (obj) config - the plugin config
		 */
		sliderNavigation: function(config) {
			
			// Create an navigation controller and append it
			// to our main container
			config._slideNavigation = $('<div>', {
				'class': config.navigationClass
			}).prependTo(config._container);
			
			var i = 1;
			while(i <= config._slidesCount) {
				var a = $('<a>', {
					'class': 'point',
					'html': i,
					'id': 'slideNavigation'+i,
					'href': '#slide'+i
				}).appendTo(config._slideNavigation);
				i++;
			}
			
			// Set first link as active
			config._activeNavigation = config._slideNavigation.find('a:first').addClass('active');
			var links = config._slideNavigation.find('a');
			
			links.bind('click', function(event) {
				config._activeSlide = parseInt($(this).text(), 10);
				window.clearInterval(config._rotateInterval);
				$.ajaxSlider.animateContainerTo(config._activeSlide -1, config);
			});
			
		},
		
		/**
		 * $.ajaxSlider.animateContainerTo
		 *
		 * This function handles the scrolling
		 * of the sliding container
		 *
		 * @param:  (int) slideNumber - Number of the active slide
		 * @param:  (obj) config - the plugin config
		 */
		animateContainerTo: function(slideNumber, config) {
		
			//slideNumber = slideNumber -1;
			if(config.layout == 'horizontal') {
				
				if(config._slidesCount > 1) {
					// Animate sliding container
					config._leftArrow.unbind('click');
					config._rightArrow.unbind('click');
					config._slideContainer.animate({
						'left': -(config.scrollWidth * slideNumber)
					}, config.scrollSpeed, function() {
						
						// Handling arrows
						if(config._slideContainer.position().left >= 0) {
							config._leftArrow.hide();
							config._rightArrow.show();
						} else if(config._slideContainer.position().left <= -(config.scrollWidth * (config._slidesCount - 1))) {
							config._leftArrow.show();
							config._rightArrow.hide();
						} else {
							config._leftArrow.show();
							config._rightArrow.show();
						}
						
						config._leftArrow.bind('click', function(event) {
							$.ajaxSlider.leftArrow(event, config);
						});
						config._rightArrow.bind('click', function(event) {
							$.ajaxSlider.rightArrow(event, config);
						});
					});
				}
			} else {
				if(config._slidesCount > 1) {
					config._slideContainer.animate({
							'top': -(config.scrollWidth * slideNumber)
						}, config.scrollSpeed, function() {
						
						if(config._slideContainer.position().top >= 0) {
							config._leftArrow.hide();
							config._rightArrow.show();
						} else if(config._slideContainer.position().top <= -(config.scrollWidth * (config._slidesCount - 1))) {
							config._leftArrow.show();
							config._rightArrow.hide();
						} else {
							config._leftArrow.show();
							config._rightArrow.show();
						}
					});
				}
			}
			
			// Set navigation point to active
			if(config.navigation === true) {
				// Set this navigation point as active
                if(config._activeNavigation) {
				    config._activeNavigation.removeClass('active');
                }
				config._activeNavigation = config._this.find('#slideNavigation'+ (slideNumber +1)).addClass('active');
			}
		},
					
		/**
		 * $.ajaxSlider.rotateSlider
		 *
		 * Rotates the slides automatically after
		 * a given given period of time
		 *
		 * @param:  (obj) config - the plugin config
		 */
		rotateSlider: function(config) {
			
			if(config._slidesCount > 1) {
				var i = 1;
				config._rotateInterval = window.setInterval(function() {
					i++;
					if(i > config._slidesCount) {
						i = 1;
					}
					config._activeSlide = i;
					$.ajaxSlider.animateContainerTo(i - 1, config);
				}, config.rotateSpeed);
			}
		},
		debugMode: function(text, config) {
			if(config.debug === true) {
				console.log(text);
			}
		}
	};
})(jQuery);

/**
 * Loading Indicator Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function($) {
	
	$.loadingIndicator = {
	
		config: {
			'overlay': '#lbOverlay',
			'overlayOpacity': 0.6,
			'hideOverlayAfterClose': false,
			'loadingClass': 'loadingIndicator',
			'loadingText': 'Loading...',
			'animationSpeed': 500,
			'additionalCSS': {},
			'bindEvent': false,
			'_loader': null
		},
		
		open: function(settings) {
			
			// settings
			if (settings) { $.extend($.loadingIndicator.config, settings); }
		
			// Create loader
			$.loadingIndicator.config._loader = $('<div>', {
				'class': $.loadingIndicator.config.loadingClass,
				'text': $.loadingIndicator.config.loadingText
			}).hide().appendTo($(document.body));
			
			var height = $.loadingIndicator.config._loader.height(), width = $.loadingIndicator.config._loader.width();
			
			$.loadingIndicator.config._loader.css({
				'marginTop':  -(height/2) +'px',
				'marginLeft': -(width/2) + 'px'
			});
			
			// Add additionalcss if passed
			if(!$.isEmptyObject($.loadingIndicator.config.additionalCSS)) {
				$.loadingIndicator.config._loader.css($.loadingIndicator.config.additionalCSS);
			}
			
			// Overlay handling
			if($.loadingIndicator.config.hideOverlayAfterClose === true) {
				$($.loadingIndicator.config.overlay).fadeTo($.loadingIndicator.config.animationSpeed, $.loadingIndicator.config.overlayOpacity);
			}
			if($.loadingIndicator.config.bindEvent === true) {
				$($.loadingIndicator.config.overlay).css({'cursor': 'pointer'}).bind('click', function() {
					$.loadingIndicator.close();
				});
			} else {
				$($.loadingIndicator.config.overlay).css({'cursor': 'default'});
			}
			if($.browser.msie && parseInt($.browser.version, 10) == 6) {
				$.ie6fix.open($.loadingIndicator.config._loader);
			} else {
				$.loadingIndicator.config._loader.fadeIn($.loadingIndicator.config.animationSpeed);
			}
			
		},
		
		close: function() {
			if($.loadingIndicator.config._loader) {
				$($.loadingIndicator.config.overlay).fadeOut($.loadingIndicator.config.animationSpeed);
				if($.browser.msie && parseInt($.browser.version, 10) == 6) {
					$.ie6fix.close($.loadingIndicator.config._loader);
				} else {
					$.loadingIndicator.config._loader.animate({
						'opacity': 0
					}, $.loadingIndicator.config.animationSpeed, function() {
						$.loadingIndicator.config._loader.remove();
					});
				}
			}
		}
	};
	
})(jQuery);

/**
 * Simple Validation
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function($) {

	//Default settings
	var config = {
		errorClass: 'instyle_error',
		successClass: 'instyle_success'
	};

	$.fn.validate = function(settings) {
		
		if (settings) { $.extend(config, settings); }
		
		this.bind('blur', function(event) {
			validate($(this));
			return false;
		});
		
		return this;
	};
	
	validate = function(el) {
		switch(el.attr('id'))
		{
			case 'register_personal_skipLogin':
			case 'register_personal_email':
			case 'register_personal_emailConfirmation':
				var action = 'ajax_validate_email';
				break;
			case 'register_billing_ustid':
				var action = 'ajax_validate_billing';
				break;
			case 'register_personal_password':
			case 'register_personal_passwordConfirmation':
				var action = 'ajax_validate_password';
				break;
		}
		
		if(!el.val()) {
			setError(el);
			return;
		} else if (action) {
			ajaxValidate(el, action);
			return;
		} else {
			setSuccess(el);
			return;
		}
	};
	
	ajaxValidate = function(el, action) {
		var data = 'action='+action+'&'+$('.register form').serialize();
		$.ajax({
            'data': data,
            'type': 'post',
            'dataType': 'json',
            'url': $.controller.ajax_validate,
            'success': function (result, data) {
				if(result && result.error_flags) 
				{
					for (var error_flag in result.error_flags)
					{  
						if(result.error_flags[error_flag]) {
							setError($('.register .'+error_flag));
						} else {
							setSuccess($('.register .'+error_flag));
						}
					}
				}
				
				$('#'+action+'_error').remove();
				
				if(result && result.error_messages&& result.error_messages.length)
				{
					var error_css = {
						'top': el.offset().top-5,
						'left': el.offset().left+el.outerWidth()+15,
						'position': 'absolute',
						'z-index': 100
					};
					
					var error_el = $('<div>').attr('id', action+'_error').addClass('error').prependTo($('body')).css(error_css);
					
					for (var error_key in result.error_messages)
					{
						var error_message = result.error_messages[error_key];

						error_el.append(error_message+'<br />');
					}
				}
            }
        });
	};
	
	//Sets error class
	setError = function(el) {
		if(!$.isEmptyObject(el)) {
			$.each($(el), function(i, e){
				$(e).removeClass(config.successClass).addClass(config.errorClass);
			});
		} else {
			$(el).removeClass(config.successClass).addClass(config.errorClass);
		}
		return el;
	};
	
	//Sets success class
	setSuccess = function(el) {
		if(!$.isEmptyObject(el)) {
			$.each($(el), function(i, e){
				$(e).removeClass(config.errorClass).addClass(config.successClass);
			});
		} else {
			$(el).removeClass(config.errorClass).addClass(config.successClass);
		}
		return el;
	};

})(jQuery);

/**
 * Liveshopping Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function($) {
	
	$.fn.liveshopping = function() {
		
		// getting liveshopping info
		this.each(function() {
			
			// setting target time
			var target = new Date();
			target.setTime($(this).find('input.valid_to_ts').val() * 1000);
			
			// collection article details
			var article = {
				'article': $(this),
				'ordernumber': $(this).find('input.ordernumber').val(),
				'target': target,
				'uniquekey': $(this).find('input.uniquekey').val(),
				'max_quantity_enable': $(this).find('input.max_quantity_enable').val(),
				'max_quantity': $(this).find('input.max_quantity').val(),
				'sells': $(this).find('input.sells').val(),
				'typeID': parseInt($(this).find('input.typeID').val(), 10),
				'price': eval($(this).find('input.price').val()),
				'minPrice': eval($(this).find('input.minPrice').val())
				//'stints': $(this).find('input.stints').val().split(';')
			};
			
			// calling init function
			$.liveshopping.init(article, this);
		});
		
	};
	
	// extends jQuery's namespace
	$.liveshopping = {
	
		// initialize the liveshopping
		init: function(article, obj) {
			
			// article limitation
			var stints = $(obj).find('input.stints');
			if($.isEmptyObject(stints) === true) {
				article.stints = $(stints).val().split(';');
			}
			
			// prepare ordernumber for sizzle
			article.ordernumber = article.ordernumber.replace(/\./g, '\\.');
			
			// refresh every second
			window.setInterval(function () {
		
				var now = $.server.dateObj;
				
				// check difference
				var diff = $.timestampDiff(article.target.getTime(), now.getTime());
				
				// liveshopping is running 
				if(diff !== false) {
				
					$.liveshopping.refreshDates(article, diff);
					
					// if type standard
					if(article.typeID == 1) {
						$.liveshopping.refreshBarChart(article,diff);
						
						if(article.max_quantity_enable) {
							$.liveshopping.refreshQuantity(article);
						}
						
					// Minutes decrease
					} else if(article.typeID == 2) {
						$.liveshopping.refreshSecondsCounter(article, diff);
						$.liveshopping.refreshPrices(article, diff);
						
					// Minutes increase
					} else {
						$.liveshopping.refreshSecondsCounter(article, diff);
						$.liveshopping.refreshPrices(article, diff);
					}
					
				// liveshopping is finished
				}
			}, 1000);
		},
		
		// changes bar chart labels which
		// are used by the standard type
		refreshDates: function(article, diff) {
			
			var key = article.uniquekey + article.ordernumber;
			
			// days
			$('span.live'+key+'_days').each(function(index, item) {
				$(item).html(diff.d);
			});
			
			// days - double digit
			$('span.live'+key+'_days_doubledigit').each(function(index, item) {
				tmp = diff.d;
				tmp = tmp.toString();
				if(tmp.length == 1) { $(item).html('0' + tmp); } else { $(item).html(tmp); }
			});
			
			// hours
			$('span.live'+key+'_hours').each(function(index, item) {
				$(item).html(diff.h);
			});
			
			// hours - double digit
			$('span.live'+key+'_hours_doubledigit').each(function(index, item) {
				tmp = diff.h;
				tmp = tmp.toString();
				if(tmp.length == 1) { $(item).html('0'+tmp); } else { $(item).html(tmp); }
			});
			
			// minutes
			$('span.live'+key+'_min').each(function(index, item) {
				$(item).html(diff.m);
			});
			
			// minutes - double digit
			$('span.live'+key+'_min_doubledigit').each(function(index, item) {
				tmp = diff.m;
				tmp = tmp.toString();
				if(tmp.length == 1) { $(item).html('0'+tmp); } else { $(item).html(tmp); }
			});
			
			// seconds
			$('span.live'+key+'_sec').each(function(index, item) {
				$(item).html(diff.s);
			});
			
			// seconds - double digit
			$('span.live'+key+'_sec_doubledigit').each(function(index, item) {
				tmp = diff.s;
				tmp = tmp.toString();
				if(tmp.length == 1) { $(item).html('0'+tmp); } else { $(item).html(tmp); }
			});

		},
		
		// refreshs the bar chart which is used in the
		// standard liveshopping type
		refreshBarChart: function(article, diff, config) {
			
			var key = article.uniquekey + article.ordernumber;
			
			// days process bar
			$('div.live'+key+'_days_process').each(function(index, item) {
				var proz = eval(diff.d)*100/31;
				if(proz > 100) { proz = 100; }
				proz = 100 - proz;
				$(item).css('width', proz+'%');
			});
			
			// hours process bar
			$('div.live'+key+'_hours_process').each(function(index, item) {
				var proz = eval(diff.h)*100/59;
				proz = 100 - proz;
				$(item).css('width', proz + '%');
			});
			
			// minutes bar chart
			$('div.live'+key+'_min_process').each(function(index, item) {
				var proz = eval(diff.m)*100/59;
				proz = 100 - proz;
				$(item).css('width', proz + '%');
			});
			
			// seconds bar chart
			$('div.live'+key+'_sec_process').each(function(index, item) {
				var proz = eval(diff.s)*100/59;
				proz = 100 - proz;
				$(item).css('width', proz + '%');
			});	

		},
		
		// necessary for minutes increase and decrease
		refreshPrices: function(article, diff) {
		
			if (diff.s === 0) {
				
				var key = article.uniquekey + article.ordernumber;
				// calulating new price
				article.article.find('input.price').each(function(index, item) {
					newPrice = eval($(item).val());
				});
				
				// setting new price
				$('strong.live'+key+'_display_price').each(function(index, item) {
					newPrice2 = newPrice;
					if(article.typeID == 3) {
						newPrice2 = eval(newPrice2) + eval(article.minPrice);
					} else {
						newPrice2 = eval(newPrice2) - eval(article.minPrice);
					}
					
					$(item).text($.number_format(newPrice2, 2, ',','.'));
				});
				
				// setting new price into hidden input
				article.article.find('input.price').val(newPrice2);
			}

		},
		
		// needed for max quantity
		refreshQuantity: function(article) {
			$('div.live'+article.uniquekey+article.ordernumber+'_instock_process').each(function(index, item) {
				var proc = eval(article.max_quantity)*100;
				var total = eval(article.max_quantity)+eval(article.sells);
				proc = proc/total;
				proc = 100 - proc;
				$(item).css('width', proc+'%');
			});
		},
		
		// refresh seconds bar
		refreshSecondsCounter: function(article, diff) {
			$('div.live'+article.uniquekey+article.ordernumber+'_secbar_process').each(function(index, item) {
				var proc = eval(diff.s)*100/59;
				$(item).css('width', proc + '%');
			});
		}
	
	};
	
})(jQuery);

/**
 * Livesearch Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
jQuery.fn.liveSearch = function (conf) {
	var config = jQuery.extend({
		url: '',
		id: 'search_results',
		duration: 400,
		typeDelay: 500,
		loadingClass: 'loading',
		onSlideUp: function () {},
		positionClass: 'active',
		position: -1,
		results: {},
		lastValue: '',
		timer: null,
		_left: null,
		_top: null
	}, conf);


	var liveSearch    = jQuery('#' + config.id);
	
	// Create live-search if it doesn't exist
	if (!liveSearch.length) {
		liveSearch = jQuery('<div id="' + config.id + '"></div>')
		.appendTo(document.body)
		.hide()
		.slideUp(0);

		// Close live-search when clicking outside it
		jQuery(document.body).click(function(event) {
			var clicked = jQuery(event.target);

			if (!(clicked.is('#' + config.id) || clicked.parents('#' + config.id).length || clicked.is('input'))) {
				liveSearch.slideUp(config.duration, function () {
					config.onSlideUp();
				});
			}
		});
	}

	return this.each(function () {
		var input = jQuery(this);
		var liveSearchPaddingBorderHoriz = parseInt(liveSearch.css('paddingLeft'), 10) + parseInt(liveSearch.css('paddingRight'), 10) + parseInt(liveSearch.css('borderLeftWidth'), 10) + parseInt(liveSearch.css('borderRightWidth'), 10);
		
		// Re calculates live search's position
		var repositionLiveSearch = function () {
		
			
			if(config._left === null || config._top === null) {
				liveSearch.show();
				if(config._left === null) { config._left = parseInt(liveSearch.css('left'), 10); }
				if(config._top === null) { config._top = parseInt(liveSearch.css('top'), 10); }
				liveSearch.hide();
			}
			
			var containerOffset = $('.container_20:first').offset();
						
			liveSearch.css({
				'left': containerOffset.left + config._left,
				'top': containerOffset.top + config._top
			});
		};

		// Shows live-search for this input
		var showLiveSearch = function () {
			// Always reposition the live-search every time it is shown
			// in case user has resized browser-window or zoomed in or whatever
			repositionLiveSearch();

			// We need to bind a resize-event every time live search is shown
			// so it resizes based on the correct input element
			$(window).unbind('resize', repositionLiveSearch);
			$(window).bind('resize', repositionLiveSearch);

			liveSearch.slideDown(config.duration);
		};

		// Hides live-search for this input
		var hideLiveSearch = function () {
			liveSearch.slideUp(config.duration, function () {
				config.onSlideUp();
			});
		};
		
		var doLiveSearch = function () {
			
			if(input.val() == config.lastValue) { return; }

			input.addClass(config.loadingClass);
		
			// Stop previous ajax-request
			if (config.timer) {
				clearTimeout(config.timer);
			}
			
			// Reset position
			config.position = -1;
			
			config.lastValue = input.val();

			// Start a new ajax-request in X ms
			config.timer = setTimeout(function () {
				
				jQuery.ajax({
	                'url': config.url,
	                'dataType': 'jsonp',
	                'cancelExisting': true,
	                'data': $(input.attr('form')).serialize(),
	                'beforeSend': function() {
						$('div.inner_searchcontainer .ajax_loader').show();
	                },
	                'success': function (request) {
	                   $('div.inner_searchcontainer .ajax_loader').hide();
	                   input.removeClass(config.loadingClass);
	                   
						// Show live-search if results and search-term aren't empty
						if (request.length) {
							liveSearch.html(request);
							config.results = jQuery('#'+config.id+ ' li');
							showLiveSearch();
						} else {
							hideLiveSearch();
						}
	                }
	            });
			}, config.typeDelay);
		};

		input
		// On focus, if the live-search is empty, perform an new search
		// If not, just slide it down. Only do this if there's something in the input
		.focus(function () {
			if (this.value !== '') {
				
				// Perform a new search if there are no search results
				if (liveSearch.html() === '') {
					config.lastValue = '';
					doLiveSearch();
				}
				// If there are search results show live search
				else {
					// HACK: In case search field changes width onfocus
					setTimeout(showLiveSearch, 1);
				}
			}
		})
		// Auto update live-search onkeyup
		.keydown(function (event) {
			
			doLiveSearch();
			
			if (config.results && config.results.length && (event.keyCode==38 || event.keyCode==40))
			{	
				$(config.results[config.position]).removeClass(config.positionClass);
				if(event.keyCode==40) {
					config.position++;
					if(config.position==config.results.length) {
						config.position = -1;
					}
				} else if(event.keyCode==38) {
					if(config.position==-1) {
						config.position = config.results.length;
					}
					config.position--;
				}
				if(config.position!=-1)
				{
					$(config.results[config.position]).addClass(config.positionClass);
				}
			}
			
			if(event.keyCode==13 && config.position!=-1) {
				
				var target = $(config.results[config.position]).find('a').attr('href');
				location.href = target;
				return false;
			}
		});
	});
};

/**
 * Utitilies Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
 
(function ($) {

	 // Methods to fix the select box bug
    // and the missing position fixed
    $.ie6fix ={
		_init: function() {
			if($.browser.msie && parseInt($.browser.version, 10) == 6) {
				$.ie6fix.open(modal, config);
			} else {
				return false;
			}
		},
		open: function(obj) {
			// Hide select boxes
			$('select:visible').css('visibility', 'hidden');
    		
    		// Fix missing 'position: fixed'
    		obj.css({
    			'position': 'absolute',
    			'top': document.body.scrollTop + 100 + 'px'
    		}).fadeIn();
    		
    		$(window).bind('scroll', function(event) {
    			obj.css('top', document.body.scrollTop + 100 + 'px');
    		});
    	},
    	close: function(obj) {
    		// Show select boxes
    		$('select:hidden').css('visibility', 'visible');
    		
    		obj.fadeOut();
    		
    		// Fix missing 'position: fixed'
    		$(window).unbind('scroll');
    	},
    	selectHide: function(selector) {
    		if(selector) {
    			$(selector + ' select, #detail .liveshopping_detail, .accessory_container').css('visibility', 'hidden');
    		} else {
    			$('select').css('visibility', 'hidden');
    		}
    	},
    	selectShow: function() {
			$('select, #detail .liveshopping_detail, .accessory_container').css('visibility', 'visible');
    	},
    	selectOnlyShow: function() {
    		$('select').css('visibility', 'visible');
    	}
    }; 

	// Formats a string
	// Syntax: $.format('<div class="%0"'>%1</div>, [value for %0], [value for %1], ...)
	$.format = function(str) {
        for (var i = 1; i < arguments.length; i++) {
            str = str.replace('%' + (i - 1), arguments[i]);
        }
        return str;
    };

	//Extends jQuery's namespace
    $.server = {
        dateObj: {}
    };
    
    //Initialized the server time which
    //is used by the liveshopping module
    $.server.init = function (servertime) {
        $.server.dateObj = new Date();
        $.server.dateObj.setTime(servertime * 1000);
        window.setInterval(function () {
            $.server.increment();
        }, 1000);
    };
    $.server.increment = function () {
        var crntTime = $.server.dateObj.getTime() + 1000;
        $.server.dateObj = new Date(crntTime);
    };
    
    //Formats floats
    $.number_format = function (number, decimals, dec_point, thousands_sep) {
        var n = number,
            prec = decimals;
        var toFixedFix = function (n, prec) {
            var k = Math.pow(10, prec);
            return (Math.round(n * k) / k).toString();
        };
        n = !isFinite(+n) ? 0 : +n;prec = !isFinite(+prec) ? 0 : Math.abs(prec);
        var sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep;
        var dec = (typeof dec_point === 'undefined') ? '.' : dec_point;
        var s = (prec > 0) ? toFixedFix(n, prec) : toFixedFix(Math.round(n), prec);
        var abs = toFixedFix(Math.abs(n), prec);
        var _, i;
        if (abs >= 1000) {
            _ = abs.split(/\D/);
            i = _[0].length % 3 || 3;
            _[0] = s.slice(0, i + (n < 0)) + _[0].slice(i).replace(/(\d{3})/g, sep + '$1');
            s = _.join(dec);
        } else {
            s = s.replace('.', dec);
        }
        var decPos = s.indexOf(dec);
        if (prec >= 1 && decPos !== -1 && (s.length - decPos - 1) < prec) {
            s += new Array(prec - (s.length - decPos - 1)).join(0) + '0';
        } else if (prec >= 1 && decPos === -1) {
            s += dec + new Array(prec).join(0) + '0';
        }
        return s;
    };
            
    //Changes the state of the related articles which is
    //used by the bundle module
    $.changeRelatedArticleState = function (ordernumber, active) {
        var tmpContainerName = '#' + ordernumber + '_related_container';
        if (false === active) {
            $(tmpContainerName).hide();
        } else {
            $(tmpContainerName).show();
        }
    };
    
    //Gets the difference between two timestamps
    //which is used by the live shopping module
    $.timestampDiff = function (d1, d2) {
        if (d1 < d2) {
            return false;
        }
        var d = Math.floor((d1 - d2) / (24 * 60 * 60 * 1000));
        var h = Math.floor(((d1 - d2) - (d * 24 * 60 * 60 * 1000)) / (60 * 60 * 1000));
        var m = Math.floor(((d1 - d2) - (d * 24 * 60 * 60 * 1000) - (h * 60 * 60 * 1000)) / (60 * 1000));
        var s = Math.floor(((d1 - d2) - (d * 24 * 60 * 60 * 1000) - (h * 60 * 60 * 1000) - (m * 60 * 1000)) / 1000);
        return {
            'd': d,
            'h': h,
            'm': m,
            's': s
        };
    };
    
    //Changes the displayed informations on the
	//article detail site and changes the active
	//images which is used by variant articles
	$.changeDetails = function (ordernumber) {
		if(ordernumber) {
			ordernumber = ordernumber.replace(/\./g, '\\.');
		}
		if (typeof($.checkNotification) == 'function') {
			if (!ordernumber){
				$.checkNotification($.ordernumber);
			}else {
				$.checkNotification(ordernumber);
			}
		}
		try {
			if(!ordernumber || $('#instock_'+ordernumber).val() > 0) {
				$('#article_notification').hide();
				$('#detailCartButton').show();
				$('#detailBuyInfoNotAvailable').hide();
			} else {
				$('#article_notification').show();
				var hideBasket = $('#notifyHideBasket').val();
				hideBasket = ~~hideBasket;
				
				if(hideBasket) {
					$('#detailCartButton').hide();
				}
				if($('#detailBuyInfoNotAvailable').length) {
					$('#detailCartButton').hide();
					$('#detailBuyInfoNotAvailable').show();
				}
			}
		} catch(e) {}

		if (!ordernumber) {
			// Hide Pseudoprice
			$('.PseudoPrice').hide();

			// Hide all other thumbnails
			if (isVariant) {
				var thumbs = $('.thumb_box').children('a:[id]');
				thumbs.each(function (i, el) {
					if ($(el).attr('id') != 'thumb' + $.ordernumber) { $(el).hide(); }
				});
			}
			// Hide delivery info
			$('.delivery_container').hide();
			// Hide basket
			$('#basketButton').css('opacity', '0.4');
		} else {
		
			// Show Pseudo price
			$('#'+ordernumber).find('.PseudoPrice').show();
			
			// Show delivery info
			$('.delivery_container').show();
			
			// Change informations
			$('#article_details').html($('#' + ordernumber).html());

			//Set basket button to active
			$('#basketButton').css('opacity', '1.0');

			// Change main image
			$('a#zoom1 img').attr('src', $('#img' + ordernumber).find('img').attr('src'));

			if(ordernumber != $.ordernumber) {

				// ZoomViewer active...
				useZoom = parseInt(useZoom);
				if(useZoom) {
					var img_link = $('a#zoom1 img');

					// Refresh src attribute
					if(img_link.attr('src')) {
						$('a#zoom1 img').attr('src', $('#img' + ordernumber).find('img').attr('src'));
					}
					// Refresh img title
					if(img_link.attr('title')) {
						img_link.attr('title', $('#img' + ordernumber).children('a').attr('title'))
					}

					// If image found and the neccessary attributes are set
					// fire the click event to change the image over the
					// CloudZoom plugin
					if(img_link.attr('src') && img_link.attr('title')) {
						$('#img' + ordernumber).find('a').trigger('click');
					}
				} else {
					 // Change lightbox link
					$('a#zoom1').attr('href', $('#img' + ordernumber).children('a').attr('href'));
				}
				
				// Change active thumbnail image
				$('#thumb' + $.ordernumber).hide();
				$('#thumb' + ordernumber).show();


				// Set the new ordernumber in the global scope
				$.ordernumber = ordernumber;
				try {
					$('#variantOrdernumber').val(ordernumber);
				}catch (err){

				}
			}
		}
		// Try to active liveshopping
		try {
			$('#article_details').liveshopping();
		} catch(err) {}
	};

    //Check if the article are set up for
    //email notification and checks if
    //a notification was sent 
    $.checkNotification = function(ordernumber) {
    	if(typeof(variantOrdernumberArray) == 'undefined') {
    		return;
    	}
    	var isSet = false;
    	try {
	    	for(var i = 0; i < variantOrdernumberArray.length; ++i) {
				if(variantOrdernumberArray[i] == ordernumber) {
					isSet = true;
					try {
						$('#articleNotificationWasSend').show();
					} catch(e) {}
					try {
						$('#sendArticleNotification').hide();
					} catch(e) {}
				}
			}
		} catch(err) {}
	}
    
})(jQuery);

/**
 * Bundle Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function($) {
	
	var config = {
		'ordernumber': $.ordernumber
	};
	
	$.bundle = {
		
		changeDetails: function(selector, ordernumber) {
			
			// setting config ordernumber
			if(typeof(ordernumber) != 'undefined') {
				config.ordernumber = ordernumber;
			} else {
				config.ordernumber = $.ordernumber;
			}
			
			var bundles = $(selector).find('.bundle_bundles_details').text();
			var related = $(selector).find('.bundle_related_articles').text();
			var article = $(selector).find('.bundle_article_details').text();
			
			// evil !!! 
			if(bundles.length) {
				eval("bundles = ("+bundles+")");
			}
			if(related.length) {
				eval("related = ("+related+")");
			}
			if(article.length) {
				eval("article = ("+article+")");
			}
			
			// Related articles
			if(typeof(related) == 'object' && parseInt(article.crossbundlelook) == 1) {
				$.bundle.processRelatedArticles(related, article);
			}
			
			// Bundles
			if(typeof(bundles) == 'object') {
				$.bundle.processBundle(bundles, article, selector);
			}
		},
		
		calculatePrice: function(bundle, ordernumber) {
		
			var articlePriceSelector = 'input#price_'+ordernumber;
			
			// Calculate total price
			var price_rab_span = $('#price_rabAbs_'+bundle.id);
			var articlePrice = $(articlePriceSelector).val();
			var bundleArticlesTotalPrice = bundle.sBundleArticlesTotalPrice.display;
			
			if(price_rab_span != null && articlePrice != null && bundleArticlesTotalPrice != null) {
				var rabTotal = eval(articlePrice) + eval(bundleArticlesTotalPrice);
				price_rab_span.text($.number_format(rabTotal, 2, ',', '.'));
			}
			
			// Calculate bundle price
			var price_bundle_span = $('#price_bundle_'+bundle.id);
			if(price_bundle_span != null) {
				
				// Calculate total discount
				if(bundle.rab_type == "abs") {
					var bundle_price = bundle.sBundlePrices.display;
					price_bundle_span.text($.number_format(bundle_price, 2, ',', '.'));
				} else {
					// Calculate percental discount
					var percentage = bundle.sBundlePrices.percentage;
					var tmpDiscount = (eval(rabTotal) / 100) * (eval(percentage));
					var bundle_price = eval(rabTotal)-eval(tmpDiscount);
					price_bundle_span.text($.number_format(bundle_price, 2, ',', '.'));
				}
			}
			
			// Discount in percentage
			var price_rabPro_span = $('#price_rabPro_'+bundle.id);
			var rabPro = 100-(eval(bundle_price) * 100 / eval(rabTotal));
			
			if(price_rabPro_span != null && rabPro != null) {
				price_rabPro_span.text($.number_format(rabPro, 2));
			}
		},
		
		processBundle: function(bundles, article, selector) {
		
			// Bundle display flag
			// Will be true if at least
			// one bundle article is active
			var showBundleBox = false;
			
			$.each(bundles,function(i, bundle) {
			
				// Mark variant ordernumber as selected article
				$('input[name=sAddBundle]').each(function(i, item) {
					$(item).val(config.ordernumber);
				});
					
				$.bundle.calculatePrice(bundle, config.ordernumber.replace('\.', '\\.'));
				
				
				// Instock check for variant articles
				if(!$.isEmptyObject(bundle.sBundleStints)) {
					
					$('.bundle').hide();
					
					$('#sAdd.variant').change(function() {
						var ordernumber = $(this).val();
						var instock = $('#instock_'+ordernumber.replace('\.', '\\.')).val();
						
						// refresh price
						$.bundle.calculatePrice(bundle, ordernumber);
						
						if(instock.length) {	
							
							if(instock >= 0) {
								if(showBundleBox) $(selector).show();
							} else {
								$('.bundle').hide();
							}
						} else {
						
							// Show bundle box, if at least one
							// one bundle artice is active
							if(showBundleBox) {
								$('.bundle').show();
							}
						}
						
					});
				}
				
				// Check if we've article limitations
				if($.isArray(bundle.sBundleStints)) {
					
					// Hide bundle box and check for
					// entitled articles
					$('#bundle_set_'+bundle.id).hide();
					
					// Pass-through ordernumber, which will
					// be displayed
					$.each(bundle.sBundleStints, function(j, stints) {
						var ordernumberToUpper = config.ordernumber.toUpperCase();
						
						if(ordernumberToUpper == stints) {
							showBundleBox = true;
							
							// show bundle box
							$('#bundleset_'+bundle.id).show();
						}
					});
				} else {
					$('.bundle').fadeIn();
				}
			});
			
			// Show bundle box, if at least one
			// one bundle artice is active
			if(showBundleBox) {
				$('.bundle').show();
			}
			
			/*if(!$.isEmptyObject(article.sVariants)) {
				$('.bundle').hide();
			} */
		},
		
		processRelatedArticles: function(related, article) {
		
			// Release related article box
			try {
				$('.relatedbox_container').show();
			} catch(err) {}
			
			// Caching ordernumber and price
			$('#related_main_ordernumber').val(config.ordernumber);
			$('#selected_articel_price').val($('#price_'+config.ordernumber).val());
			$.refreshRelatedArticle();
			
			// Deposit images
			try {
				var tmpBundleImg = $('#related_main_image');
				var tmpSourceImg = $('#img_1_'+config.ordernumber);
				
				if(tmpSourceImg != null) {tmpBundleImg.html(tmpSourceImg.html());}
			} catch(err) {}
		}
		
	};
	
	
	// Main bundle function
	// exam.: $('.bundlebox').bundle();
	$.fn.bundle = function(settings) {
		
		if (settings) $.extend(config, settings);
		
		this.each(function() {
			$.bundle.changeDetails(this);
		});
	};
	
	//Refreshes the relatedArticles which is
    //used by the bundle module
    $.refreshRelatedArticle = function () {
        var relatedOrdernumbers = '';
        var totalPrice = $('#selected_articel_price').val();
        
        $('input[class=relatedOrdernumber]').each(function (i, item) {
            var tmpOrdernumber = $(item).val();
			
			/**
			 * Fix issue with sizzle selector engine and ordernumbers
			 * which includes dots
			 * @ticket #5711 (intern)
			 * @ticket #100483 (extern)
			 * @author s.pohl
			 * @date 2011-07-27
			 */
			tmpOrdernumber = tmpOrdernumber.replace(/(:|\.)/g,'\\$1');

            var tmpContainerName = '#related_'+tmpOrdernumber+'_image';
            var tmpPlusiconName = '#related_'+tmpOrdernumber+'_plus';
            var tmpPriceName = '#' + tmpOrdernumber + '_price';
            var checkbox = $('#' + tmpOrdernumber + '_related_checkbox');
            if (checkbox.is(':checked')) {
                $(tmpContainerName).fadeIn('fast');
                $(tmpPlusiconName).fadeIn('fast');
                if ('' == relatedOrdernumbers) relatedOrdernumbers = tmpOrdernumber;
                else relatedOrdernumbers += ';' + tmpOrdernumber;
                var tmpPrice = $(tmpPriceName).val();
                if (tmpPrice) totalPrice = eval(totalPrice) + eval(tmpPrice)
            } else {
                $(tmpContainerName).fadeOut('fast');
                $(tmpPlusiconName).fadeOut('fast');
            }
        });
        $('#sRelatedOrdernumbers').val(relatedOrdernumbers);
        $('#price_relatedbundle').html($.number_format(totalPrice, 2, ',', '.'));
    };

})(jQuery);

/**
 * Compare Plugin
 * for Shopware
 * 
 * Shopware AG (c) 2010
 */
(function($) {

	//Extends jQuery's namespace
    $.compare = {};
    
    //Default options
    $.compare.options = {
        viewportAjax: '',
        compareContainer: '#compare_bigbox',
        compareOverlay: '#lbOverlay',
        resultsContainer: '#compareContainerResults',
        ajaxContainer: '#compareContainerAjax',
        compareHighlight: '#compareHighlight',
        highlightSpeed: 1750,
        highlightColor: '#dd4800',
        dataType: 'json',
        requestType: 'post',
        animationSpeed: 400,
        topLink: '#top',
        maxCount: 5,
        compareCount:  0
    };
    
    //Sets user settings
    $.compare.setup = function (params) {
    	if(params)
        $.each(params, function (i, param) {
            $.compare.options[i] = param
        });
		
		if(compareMaxCount) {
        	$.compare.options.maxCount = parseInt(compareMaxCount);
        }
        if(compareCount) {
    		$.compare.options.compareCount = parseInt(compareCount);
		}
        
        //binding events
        $('.compare_delete_all').live('click', function(event) {
        	$.compare.deleteComparisons(this.href);
        	event.preventDefault();
        });
        $('.compare_add_article').live('click', function(event) {
        	$.compare.addCompare(this.href);
        	event.preventDefault();
        });
        $('.compare_get_overlay').live('click', function(event) {
        	$.compare.startComparison(this.href);
        	event.preventDefault();
        });
        $('.compare_delete_article').live('click', function(event) {
        	$.compare.deleteCompare(this.href);
        	event.preventDefault();
        });
    };
    
    //Displays the compare container
    $.compare.showCompare = function () {
    	$($.compare.options.compareHighlight).addClass('active');
        $($.compare.options.resultsContainer).show();
    };
    
    //Hides the compare container
    $.compare.hideCompare = function () {
    	$($.compare.options.compareHighlight).removeClass('active');
        $($.compare.options.resultsContainer).hide();
    };
    
    //Hides the compare window
    $.compare.hideCompareList = function () {
        $($.compare.options.compareContainer).animate({
            'top': -($($.compare.options.compareContainer).height()+100)+'px'
        });
        $($.compare.options.compareOverlay).fadeOut();
    };
    
    //Requests the compare informations
	$.compare.startComparison = function (url) {
	    $.ajax({
	        'dataType': $.compare.options.dataType,
	        'type': $.compare.options.requestType,
	        'url': url,
	        'complete': function (result) {
	        	
	        	var container = $('<div>', {'class':'ajax_compare_container'}).appendTo(document.body);
	        	var div = $('<div>', {'class': 'grid_3'}).appendTo(container);
	        	
	        	container.show();	
	        	var tmpWidth = parseInt(div.css('width'));
	        	container.remove();
	        	
				var width = tmpWidth * $.compare.options.compareCount + tmpWidth;
				
				if($.browser.msie && parseInt($.browser.version) == 6) {
					width += 2;
				}
	            
				$.modal(result.responseText, '', {
	           		'width': width+'px',
	           		'top': '30px',
	           		'textContainer': '<div>',
	           		'textClass': 'ajax_compare_container'
	           });
	        }
	    })
	};
	
    //Adds an article with it's article id
    //to the current compare list
    $.compare.addCompare = function (url) {
        $.ajax({
            'dataType': $.compare.options.dataType,
            'type': $.compare.options.requestType,
            'url': url,
            'complete': function (result) {
            	$.compare.options.compareCount = $.compare.options.compareCount + 1;
            	if($.compare.options.compareCount > $.compare.options.maxCount) {
            	
            		var width = 500;
            		var position = 'fixed';
            		
            		if($.browser.msie && parseInt($.browser.version) == 6) {
						width += 2;
						position = 'absolute';
					}
		            $.modal(result.responseText, '', {
		        		'position': position,
		        		'width': width+'px',
		        		'textContainer': '<div>',
		        		'textClass': 'ajax_compare_max_container'
		        	});
		        	$.compare.options.compareCount = $.compare.options.maxCount;
		        	return;
            	}
	            $($.compare.options.ajaxContainer).html(result.responseText);
                window.location = $.compare.options.topLink;
            }
        })
    };
    
    //Deletes an article with it's article id
    //from the current compare list
    $.compare.deleteCompare = function (url) {
        $.ajax({
            'dataType': $.compare.options.dataType,
            'type': $.compare.options.requestType,
            'url': url,
            'beforeSend': function() {
            	$.compare.options.compareCount = $.compare.options.compareCount - 1;
            	compareCount = $.compare.options.compareCount - 1;
            },
            'complete': function (result) {
                $($.compare.options.ajaxContainer).html(result.responseText);
                
            }
        })
    };
    
    //Deletes the current compare list
    $.compare.deleteComparisons = function (url) {
        $.ajax({
            'dataType': $.compare.options.dataType,
            'type': $.compare.options.requestType,
            'url': url,
            'beforeSend': function() {
            	$.compare.options.compareCount = 0;
            	compareCount = $.compare.options.compareCount;
            },
            'complete': function () {
                $($.compare.options.ajaxContainer).empty();
            }
        })
    };
})(jQuery);

/**
 * Modal Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function ($) {
	
	//Default settings
	var config = {
	    animationSpeed: 500,
	    frameHeight: '500px',
	    textClass: '',
	    textContainer: '<p>',
	    overlay: '#lbOverlay',
	    overlayOpacity: '0.6',
	    useOverlay: true,
	    width: 500
	};
	
	//creates an modal window with text and headline
	$.modal = function (text, headline, settings) {
        settings = settings || {};
        settings = $.extend({}, config, settings);

	    if ($('.modal')) $('.modal').remove();
	    var modal = $('<div>', {
	        'class': 'modal',
	        'css': {
	        	'width': settings.width
	        } 
	    });

	    if (headline.length) {
	        var h2 = $('<h2>', {
	            'html': headline
	        }).appendTo(modal)
	    }
	    if (text.length) {
	        var container = $(settings.textContainer, {
	            'html': text
	        });
	        
	        if (settings.textClass.length) {
	            container.addClass(settings.textClass)
	        }
	        container.appendTo(modal);
	    }
	    
	    //get css properties
	    modal.show();
	    if(!settings.position) {
            settings.position = modal.css('position');
	    }
        settings.top = modal.css('top');
	    modal.hide();
	    
	  
	    modal.appendTo('body');
	    
	    modal.show().css('marginLeft', -(modal.width()/2)).hide();
	    
	    if (settings.useOverlay == true) {
	        $.modal.overlay.fadeIn();
	        
	        $(settings.overlay).bind('click', function (event) {
	            $.modalClose();
	        })
	    }
	    $('.modal').fadeIn('fast');
	    
	    if($.browser.msie && parseInt($.browser.version) == 6) {
	 		$.ie6fix.open(modal, settings);
	 	} else {
	        if (settings.position == 'absolute') {
	            modal.css({
	                'position': settings.position,
	                'bottom': 'auto'
	            }).fadeIn(settings.animationSpeed);
	        } else if (settings.position == 'fixed') {
	        	$('.modal').fadeIn();
	            modal.css({
	                'position': settings.position,
	                'top': -(modal.height() + 100) + 'px',
	                'display': 'block'
	            }).animate({
	                'top': '40px'
	            }, settings.animationSpeed)
	        }
	    }
	    
	    return modal
	};
    
    //Cloeses the current modal window
    $.modalClose = function () {
        if (config.useOverlay == true) {
            $.modal.overlay.fadeOut()
        }
        
        if($.browser.msie && parseInt($.browser.version) == 6) {
        	$.ie6fix.close($('.modal'), config);
        } else {
	        if (config.position == 'absolute') {
	            $('.modal').fadeOut(config.animationSpeed)
	        } else if (config.position == 'fixed') {
	            $('.modal').animate({
	                'top': -($('.modal').height() + 100) + 'px'
	            }, config.animationSpeed)
	        }
	        $('.modal').fadeOut();
        }
    };
    
    //Creates a modal window with an iframe and a headline
    $.modalFrame = function (url, headline, settings) {
        if (settings) $.extend(config, settings);
        config.animationSpeed = parseInt(config.animationSpeed);
        if ($('.modal')) $('.modal').remove();
        var modal = $('<div>', {
            'class': 'modal',
            'css': {
                'width': config.width,
                'left': '50%',
                'border': config.border,
                'padding': config.padding,
                'background': config.background,
                'display': 'none',
                'margin-left': -(parseInt(config.width) / 2)
            }
        });
        if (headline.length) {
            var h2 = $('<h2>', {
                'text': headline
            }).appendTo(modal)
        }
        if (url.length) {
            var div = $('<iframe>', {
                'src': url,
                'css': {
                    'height': config.frameHeight
                }
            }).appendTo(modal)
        }
        var close = $('<a>', {
            'text': 'Schließen',
            'class': 'close'
        }).appendTo(modal);
        close.bind('click', function (event) {
            event.preventDefault();
            if (config.position == 'absolute') {
                modal.fadeOut(config.animationSpeed)
            } else if (config.position == 'fixed') {
                modal.animate({
                    'top': -(modal.height() + 100) + 'px'
                }, config.animationSpeed)
            }
        });
        modal.appendTo('.container_20');
        if (config.position == 'absolute') {
            modal.css({
                'position': config.position
            }).fadeIn(config.animationSpeed)
        } else if (config.position == 'fixed') {
            modal.css({
                'position': config.position,
                'top': -(modal.height() + 100) + 'px',
                'display': 'block'
            }).animate({
                'top': '0%'
            }, config.animationSpeed)
        }
    };
        
    //Handles the modal overlay
    $.modal.overlay = {
        fadeIn: function () {
            $(config.overlay).css({
                'display': 'block',
                'opacity': '0'
            }).animate({
                'opacity': '0.4'
            }, 500)
        },
        fadeOut: function () {
            $(config.overlay).animate({
                'opacity': '0'
            }, 500).hide()
        }
    }
})(jQuery);


/**
 * AJAX Login Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function ($) {

	//Default settings
    var config = {
        dataType: 'text',
        container: '.modal',
        headline: '',
        viewport: '',
        register: '',
        checkout: '',
        target: ''
    };
    
    //Extends jQuery's function namespace
	$.fn.checkout = function (settings) {
	    if (settings) $.extend(config, settings);
	    
	    $(config.container + ' form').live('submit', function (event) {
	    	if(!$(this).hasClass('new_customer_form')) {
	    		event.preventDefault();
	    		$.checkout.loginUser(this);
	    	}
	    });
	    $(config.container + ' .existing_customer input[type^=submit]').live('click', function(event) {
	    	event.preventDefault();
	    	var form = $(config.container + ' form[name^=existing_customer]');
	    	$.checkout.loginUser(form);
	    });
	    
	    this.live('click', function (event) {
	        event.preventDefault();
	        $.checkout.checkUser(this.href);
	    });
	    
	    return this
	};

    
    //Extends jQuery's namespace
    $.checkout = {};
    
    //Checks the user
    $.checkout.checkUser = function (target,event) {
    	config.target = target;
        $.ajax({
            'url': config.viewport,
            'dataType': 'jsonp',
            'success': function (result) {
                if (result.length) {
                	var width = 530;
                	var position = 'fixed';

                	if($.browser.msie && parseInt($.browser.version) == 6) {
                		var width = 530;
                		var position = 'absolute';
                	}

                    $.modal(result, config.headline, {
                        'position': position,
                        'textClass': '',
                        'textContainer': '<div>',
                        'width': width+'px'
                    }).find('.close').remove();

                    if($.browser.msie) {
	                    buttons = $('.modal').find('input[type^=submit]');
	                    buttons.each(function() {
	                    	this.fireEvent('onmove');
	                    });
                    }
                
                // user is logged in                
                } else {
					window.location.href = target;
                }
            }
        });
    };
    
    //Checks if the user is logged in
    $.checkout.loginUser = function (form) {
    	config.register  = $.controller.register;
        $.ajax({
            'url': config.viewport,
            'dataType': 'jsonp',
            'data': $(form).serialize(),
            'success': function (result) {
            	if(result.length) {
            		$(config.container).empty().html(result);
            	} else {
            		 window.location.href = config.target ? config.target : config.checkout;
            	}
            }
        });
    };
})(jQuery);

/**
 * AJAX Basket Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function ($) {
	
	//Extends jQuery's namespace
    $.basket = {};
    
    //Default settings
    $.basket.options = {
        viewport: '',
        basketLoader: '.ajax_basket .ajax_loader',
        basketResult: '.ajax_basket_result',
        basketDisplay: '#shopnavi div.display_basket',
        basketParent: '.ajax_basket_container'
    };
    
    //Initialize the basket module
    //and binds the needed events
    $.basket.init = function () {
    	
    	var width = 660;
    	var position = 'fixed';
    	
    	if($.browser.msie && parseInt($.browser.version) == 6) {
    		var width = width - 10;
    		var position = 'absolute';
    	}
    	
    
        var modalConfig = {
            'position': position,
            'animationSpeed': 200,
            'width': width+'px',
            'textContainer': '<div>',
            'textClass': 'ajax_add_article_container'
        };
        var sliderConfig = {
       		'headline': false,
			'navigation': false,
			'scrollSpeed': 800,
			'rotate': false,
			'width':630,
			'height': 210,
			'scrollWidth': 578,
			'containerCSS': {
				'margin': '0 0 15px 15px'
			}
        };
        
        $('a.buynow').live('click', function (event) {
            event.preventDefault();

			$.loadingIndicator.open();
            $.ajax({
                'dataType': 'jsonp',
                'url': $(this).attr('href'),
                'success': function (result) {
                	$.loadingIndicator.close();
                    $.modal(result, '', modalConfig);
                    $('#lbOverlay').css('opacity', '0').show().fadeTo('fast', '0.3');
                    
                    $('.slider_modal').ajaxSlider('locale', sliderConfig);
                    
                    $('.modal .close').hide();
                    $.basket.refreshDisplay();
                }
            })
        });
        $('.basketform').bind('submit', function (event) {
            event.preventDefault();
			
			$.loadingIndicator.open();
            $.ajax({
                'data': $(this).serialize(),
                'dataType': 'jsonp',
                'url': $(this).attr('action'),
                'success': function(result) {
                	
                	$.loadingIndicator.close();
                    $.modal(result, '', modalConfig);
                    $('#lbOverlay').css('opacity', '0').show().fadeTo('fast', '0.3');
                	
                	$('.slider_modal').ajaxSlider('locale', sliderConfig);
					
                    $('.modal .close').hide();
                    $.basket.refreshDisplay();
                }
            });
        });
    };
    
    //Refreshs the basket display
    $.basket.refreshDisplay = function () {
        $.ajax({
            'dataType': 'jsonp',
            'url': $.basket.options.viewport,
            'data': {
            	'sAction': 'ajaxAmount'
            },
            'success': function (result) {
                $($.basket.options.basketDisplay).html(result)
            }
        })
    };
    
    //Requests the basket content
    $.basket.getBasket = function () {
        if(!$($.basket.options.basketResult).length) {
        	$('<div>', {
        		'class': 'ajax_basket_result'
        	}).appendTo(document.body);
        }
        $($.basket.options.basketLoader).show();
        $.ajax({
            'data': {
                'sAction': 'ajaxCart'
            },
            'dataType': 'jsonp',
            'url': $.basket.options.viewport,
            'success': function (result) {
            	var offset = $($.basket.options.basketParent).offset();
            	$($.basket.options.basketResult).css({
            		'top': offset.top + 22,
            		'left': offset.left -($($.basket.options.basketResult).width() - $($.basket.options.basketParent).width() + 20)
            	});
                $($.basket.options.basketLoader).hide();
                if (result.length) {
                    $($.basket.options.basketResult).empty().html(result);
                } else {
                    $($.basket.options.basketResult).empty().html($.basket.options.emptyText);
                }
                $($.basket.options.basketResult).addClass('active').slideDown('fast');
                $(document.body).bind('click', function() {
					$($.basket.options.basketResult).removeClass('active').slideUp('fast');
					$(document.body).unbind('click');
				});
            }
        })
    }
})(jQuery);

/**
 * Topseller Accordion Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function ($) {

	//Extends jQuery's function namespace
    $.fn.kwicks = function (n) {
        var p = {
            isVertical: true,
            sticky: false,
            defaultKwick: 0,
            event: 'mouseover',
            spacing: 0,
            duration: 500
        };
        var o = $.extend(p, n);
        var q = (o.isVertical ? 'height' : 'width');
        var r = (o.isVertical ? 'top' : 'left');
        return this.each(function () {
        	$(this).parent().show();
            container = $(this);
            var k = container.children('li');
            //var l = k.eq(0).css(q).replace(/px/, '');
            var l = 0;
	        k.each(function (i) {
	        	l += Math.floor($(this).css(q).replace(/px/, ''));
	        });
	        l /= k.size();
            
            if (!o.max) {
                o.max = (l * k.size()) - (o.min * (k.size() - 1))
            } else {
                o.min = ((l * k.size()) - o.max) / (k.size() - 1)
            }
            if (o.isVertical) {
                container.css({
                    width: k.eq(0).css('width'),
                    height: (l * k.size()) + (o.spacing * (k.size() - 1)) + 'px'
                })
            } else {
                container.css({
                    width: (l * k.size()) + (o.spacing * (k.size() - 1)) + 'px',
                    height: k.eq(0).css('height')
                })
            }
            var m = [];
            for (i = 0; i < k.size(); i++) {
                m[i] = [];
                for (j = 1; j < k.size() - 1; j++) {
                    if (i == j) {
                        m[i][j] = o.isVertical ? j * o.min + (j * o.spacing) : j * o.min + (j * o.spacing)
                    } else {
                        m[i][j] = (j <= i ? (j * o.min) : (j - 1) * o.min + o.max) + (j * o.spacing)
                    }
                }
            }
            k.each(function (i) {
                var h = $(this);
                if (i === 0) {
                    h.css(r, '0px')
                } else if (i == k.size() - 1) {
                    h.css(o.isVertical ? 'bottom' : 'right',
                    '0px')
                } else {
                    if (o.sticky) {
                        h.css(r, m[o.defaultKwick][i])
                    } else {
                        h.css(r, (i * l) + (i * o.spacing))
                    }
                }
                if (o.sticky) {
                    if (o.defaultKwick == i) {
                        h.css(q, o.max + 'px');
                        h.addClass('active')
                    } else {
                        h.css(q, o.min + 'px')
                    }
                }
                h.css({
                    margin: 0,
                    position: 'absolute'
                });
                h.bind(o.event, function () {
                    var c = [];
                    var d = [];
                    k.stop().removeClass('active');
                    for (j = 0; j < k.size(); j++) {
                        c[j] = k.eq(j).css(q).replace(/px/, '');
                        d[j] = k.eq(j).css(r).replace(/px/, '')
                    }
                    var e = {};
                    e[q] = o.max;
                    var f = o.max - c[i];
                    var g = c[i] / f;
                    h.addClass('active').animate(e, {
                        step: function (a) {
                            var b = f != 0 ? a / f - g : 1;k.each(function (j) {
                                if (j != i) {
                                    k.eq(j).css(q, c[j] - ((c[j] - o.min) * b) + 'px')
                                }
                                if (j > 0 && j < k.size() - 1) {
                                    k.eq(j).css(r, d[j] - ((d[j] - m[i][j]) * b) + 'px')
                                }
                            })
                        },
                        duration: o.duration,
                        easing: o.easing
                    })
                })
            });
            if (!o.sticky) {
                container.bind("mouseleave", function () {
                    var c = [];
                    var d = [];
                    k.removeClass('active').stop();
                    for (i = 0; i < k.size(); i++) {
                        c[i] = k.eq(i).css(q).replace(/px/, '');
                        d[i] = k.eq(i).css(r).replace(/px/, '')
                    }
                    var e = {};
                    e[q] = l;
                    var f = l - c[0];
                    k.eq(0).animate(e, {
                        step: function (a) {
                            var b = f != 0 ? (a - c[0]) / f : 1;
                            for (i = 1; i < k.size(); i++) {
                                k.eq(i).css(q, c[i] - ((c[i] - l) * b) + 'px');
                                if (i < k.size() - 1) {
                                    k.eq(i).css(r, d[i] - ((d[i] - ((i * l) + (i * o.spacing))) * b) + 'px')
                                }
                            }
                        },
                        duration: o.duration,
                        easing: o.easing
                    })
                })
            }
        })
    }
})(jQuery);

/**
 * Supplier Filter
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function($) {

	//Default setttings
	var config = {
		slideContainer: '.supplier_filter .slideContainer',
		plus: '.filter_actions .plus',
		plusText: '+',
		minus:  '.filter_actions .minus',
		minusText: '-',
		expander: '.expandcollapse',
		expandAll: '.supplier_filter div .expandcollapse',
		activeClass: 'active',
		animationSpeed: 'fast'
	};
	
	$.fn.supplierfilter = function(settings) {
		
		//Extends default settings with user settings
		if (settings) $.extend(config, settings);
		
		this.each(function() {
		
			//Hides the container on start up
			($(this).find('li').hasClass(config.activeClass)) ? $(this).show() : $(this).hide();
			
			//Bind click event on span
			$(this).prev('div').bind('click', function() {
				$(this).toggleClass(config.activeClass).next('.slideContainer').slideToggle(config.animationSpeed);
				($(this).hasClass(config.activeClass)) ? $(this).children(config.expander).text(config.minusText) : $(this).children(config.expander).text(config.plusText);
			});
		});
		
	return this;
	};

})(jQuery);


/**
 * jQuery UI 1.8.1
 *
 * Copyright (c) 2010 AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * http://docs.jquery.com/UI
 */
jQuery.ui||function(c){c.ui={version:"1.8.1",plugin:{add:function(a,b,d){a=c.ui[a].prototype;for(var e in d){a.plugins[e]=a.plugins[e]||[];a.plugins[e].push([b,d[e]])}},call:function(a,b,d){if((b=a.plugins[b])&&a.element[0].parentNode)for(var e=0;e<b.length;e++)a.options[b[e][0]]&&b[e][1].apply(a.element,d)}},contains:function(a,b){return document.compareDocumentPosition?a.compareDocumentPosition(b)&16:a!==b&&a.contains(b)},hasScroll:function(a,b){if(c(a).css("overflow")=="hidden")return false;
b=b&&b=="left"?"scrollLeft":"scrollTop";var d=false;if(a[b]>0)return true;a[b]=1;d=a[b]>0;a[b]=0;return d},isOverAxis:function(a,b,d){return a>b&&a<b+d},isOver:function(a,b,d,e,f,g){return c.ui.isOverAxis(a,d,f)&&c.ui.isOverAxis(b,e,g)},keyCode:{ALT:18,BACKSPACE:8,CAPS_LOCK:20,COMMA:188,CONTROL:17,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,INSERT:45,LEFT:37,NUMPAD_ADD:107,NUMPAD_DECIMAL:110,NUMPAD_DIVIDE:111,NUMPAD_ENTER:108,NUMPAD_MULTIPLY:106,NUMPAD_SUBTRACT:109,PAGE_DOWN:34,PAGE_UP:33,
PERIOD:190,RIGHT:39,SHIFT:16,SPACE:32,TAB:9,UP:38}};c.fn.extend({_focus:c.fn.focus,focus:function(a,b){return typeof a==="number"?this.each(function(){var d=this;setTimeout(function(){c(d).focus();b&&b.call(d)},a)}):this._focus.apply(this,arguments)},enableSelection:function(){return this.attr("unselectable","off").css("MozUserSelect","")},disableSelection:function(){return this.attr("unselectable","on").css("MozUserSelect","none")},scrollParent:function(){var a;a=c.browser.msie&&/(static|relative)/.test(this.css("position"))||
/absolute/.test(this.css("position"))?this.parents().filter(function(){return/(relative|absolute|fixed)/.test(c.curCSS(this,"position",1))&&/(auto|scroll)/.test(c.curCSS(this,"overflow",1)+c.curCSS(this,"overflow-y",1)+c.curCSS(this,"overflow-x",1))}).eq(0):this.parents().filter(function(){return/(auto|scroll)/.test(c.curCSS(this,"overflow",1)+c.curCSS(this,"overflow-y",1)+c.curCSS(this,"overflow-x",1))}).eq(0);return/fixed/.test(this.css("position"))||!a.length?c(document):a},zIndex:function(a){if(a!==
undefined)return this.css("zIndex",a);if(this.length){a=c(this[0]);for(var b;a.length&&a[0]!==document;){b=a.css("position");if(b=="absolute"||b=="relative"||b=="fixed"){b=parseInt(a.css("zIndex"));if(!isNaN(b)&&b!=0)return b}a=a.parent()}}return 0}});c.extend(c.expr[":"],{data:function(a,b,d){return!!c.data(a,d[3])},focusable:function(a){var b=a.nodeName.toLowerCase(),d=c.attr(a,"tabindex");return(/input|select|textarea|button|object/.test(b)?!a.disabled:"a"==b||"area"==b?a.href||!isNaN(d):!isNaN(d))&&
!c(a)["area"==b?"parents":"closest"](":hidden").length},tabbable:function(a){var b=c.attr(a,"tabindex");return(isNaN(b)||b>=0)&&c(a).is(":focusable")}})}(jQuery);

/**
 * jQuery UI Widget 1.8.1
 *
 * Copyright (c) 2010 AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * http://docs.jquery.com/UI/Widget
 */
(function(b){var j=b.fn.remove;b.fn.remove=function(a,c){return this.each(function(){if(!c)if(!a||b.filter(a,[this]).length)b("*",this).add(this).each(function(){b(this).triggerHandler("remove")});return j.call(b(this),a,c)})};b.widget=function(a,c,d){var e=a.split(".")[0],f;a=a.split(".")[1];f=e+"-"+a;if(!d){d=c;c=b.Widget}b.expr[":"][f]=function(h){return!!b.data(h,a)};b[e]=b[e]||{};b[e][a]=function(h,g){arguments.length&&this._createWidget(h,g)};c=new c;c.options=b.extend({},c.options);b[e][a].prototype=
b.extend(true,c,{namespace:e,widgetName:a,widgetEventPrefix:b[e][a].prototype.widgetEventPrefix||a,widgetBaseClass:f},d);b.widget.bridge(a,b[e][a])};b.widget.bridge=function(a,c){b.fn[a]=function(d){var e=typeof d==="string",f=Array.prototype.slice.call(arguments,1),h=this;d=!e&&f.length?b.extend.apply(null,[true,d].concat(f)):d;if(e&&d.substring(0,1)==="_")return h;e?this.each(function(){var g=b.data(this,a),i=g&&b.isFunction(g[d])?g[d].apply(g,f):g;if(i!==g&&i!==undefined){h=i;return false}}):this.each(function(){var g=
b.data(this,a);if(g){d&&g.option(d);g._init()}else b.data(this,a,new c(d,this))});return h}};b.Widget=function(a,c){arguments.length&&this._createWidget(a,c)};b.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",options:{disabled:false},_createWidget:function(a,c){this.element=b(c).data(this.widgetName,this);this.options=b.extend(true,{},this.options,b.metadata&&b.metadata.get(c)[this.widgetName],a);var d=this;this.element.bind("remove."+this.widgetName,function(){d.destroy()});this._create();
this._init()},_create:function(){},_init:function(){},destroy:function(){this.element.unbind("."+this.widgetName).removeData(this.widgetName);this.widget().unbind("."+this.widgetName).removeAttr("aria-disabled").removeClass(this.widgetBaseClass+"-disabled ui-state-disabled")},widget:function(){return this.element},option:function(a,c){var d=a,e=this;if(arguments.length===0)return b.extend({},e.options);if(typeof a==="string"){if(c===undefined)return this.options[a];d={};d[a]=c}b.each(d,function(f,
h){e._setOption(f,h)});return e},_setOption:function(a,c){this.options[a]=c;if(a==="disabled")this.widget()[c?"addClass":"removeClass"](this.widgetBaseClass+"-disabled ui-state-disabled").attr("aria-disabled",c);return this},enable:function(){return this._setOption("disabled",false)},disable:function(){return this._setOption("disabled",true)},_trigger:function(a,c,d){var e=this.options[a];c=b.Event(c);c.type=(a===this.widgetEventPrefix?a:this.widgetEventPrefix+a).toLowerCase();d=d||{};if(c.originalEvent){a=
b.event.props.length;for(var f;a;){f=b.event.props[--a];c[f]=c.originalEvent[f]}}this.element.trigger(c,d);return!(b.isFunction(e)&&e.call(this.element[0],c,d)===false||c.isDefaultPrevented())}}})(jQuery);

/**
 * jQuery UI Tabs 1.8.1
 *
 * Copyright (c) 2010 AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * http://docs.jquery.com/UI/Tabs
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 */
(function(d){var s=0,u=0;d.widget("ui.tabs",{options:{add:null,ajaxOptions:null,cache:false,cookie:null,collapsible:false,disable:null,disabled:[],enable:null,event:"click",fx:null,idPrefix:"ui-tabs-",load:null,panelTemplate:"<div></div>",remove:null,select:null,show:null,spinner:"<em>Loading&#8230;</em>",tabTemplate:'<li><a href="#{href}"><span>#{label}</span></a></li>'},_create:function(){this._tabify(true)},_setOption:function(c,e){if(c=="selected")this.options.collapsible&&e==this.options.selected||
this.select(e);else{this.options[c]=e;this._tabify()}},_tabId:function(c){return c.title&&c.title.replace(/\s/g,"_").replace(/[^A-Za-z0-9\-_:\.]/g,"")||this.options.idPrefix+ ++s},_sanitizeSelector:function(c){return c.replace(/:/g,"\\:")},_cookie:function(){var c=this.cookie||(this.cookie=this.options.cookie.name||"ui-tabs-"+ ++u);return d.cookie.apply(null,[c].concat(d.makeArray(arguments)))},_ui:function(c,e){return{tab:c,panel:e,index:this.anchors.index(c)}},_cleanup:function(){this.lis.filter(".ui-state-processing").removeClass("ui-state-processing").find("span:data(label.tabs)").each(function(){var c=
d(this);c.html(c.data("label.tabs")).removeData("label.tabs")})},_tabify:function(c){function e(g,f){g.css({display:""});!d.support.opacity&&f.opacity&&g[0].style.removeAttribute("filter")}this.list=this.element.find("ol,ul").eq(0);this.lis=d("li:has(a[href])",this.list);this.anchors=this.lis.map(function(){return d("a",this)[0]});this.panels=d([]);var a=this,b=this.options,h=/^#.+/;this.anchors.each(function(g,f){var j=d(f).attr("href"),l=j.split("#")[0],p;if(l&&(l===location.toString().split("#")[0]||
(p=d("base")[0])&&l===p.href)){j=f.hash;f.href=j}if(h.test(j))a.panels=a.panels.add(a._sanitizeSelector(j));else if(j!="#"){d.data(f,"href.tabs",j);d.data(f,"load.tabs",j.replace(/#.*$/,""));j=a._tabId(f);f.href="#"+j;f=d("#"+j);if(!f.length){f=d(b.panelTemplate).attr("id",j).addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").insertAfter(a.panels[g-1]||a.list);f.data("destroy.tabs",true)}a.panels=a.panels.add(f)}else b.disabled.push(g)});if(c){this.element.addClass("ui-tabs ui-widget ui-widget-content ui-corner-all");
this.list.addClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all");this.lis.addClass("ui-state-default ui-corner-top");this.panels.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom");if(b.selected===undefined){location.hash&&this.anchors.each(function(g,f){if(f.hash==location.hash){b.selected=g;return false}});if(typeof b.selected!="number"&&b.cookie)b.selected=parseInt(a._cookie(),10);if(typeof b.selected!="number"&&this.lis.filter(".ui-tabs-selected").length)b.selected=
this.lis.index(this.lis.filter(".ui-tabs-selected"));b.selected=b.selected||(this.lis.length?0:-1)}else if(b.selected===null)b.selected=-1;b.selected=b.selected>=0&&this.anchors[b.selected]||b.selected<0?b.selected:0;b.disabled=d.unique(b.disabled.concat(d.map(this.lis.filter(".ui-state-disabled"),function(g){return a.lis.index(g)}))).sort();d.inArray(b.selected,b.disabled)!=-1&&b.disabled.splice(d.inArray(b.selected,b.disabled),1);this.panels.addClass("ui-tabs-hide");this.lis.removeClass("ui-tabs-selected ui-state-active");
if(b.selected>=0&&this.anchors.length){this.panels.eq(b.selected).removeClass("ui-tabs-hide");this.lis.eq(b.selected).addClass("ui-tabs-selected ui-state-active");a.element.queue("tabs",function(){a._trigger("show",null,a._ui(a.anchors[b.selected],a.panels[b.selected]))});this.load(b.selected)}d(window).bind("unload",function(){a.lis.add(a.anchors).unbind(".tabs");a.lis=a.anchors=a.panels=null})}else b.selected=this.lis.index(this.lis.filter(".ui-tabs-selected"));this.element[b.collapsible?"addClass":
"removeClass"]("ui-tabs-collapsible");b.cookie&&this._cookie(b.selected,b.cookie);c=0;for(var i;i=this.lis[c];c++)d(i)[d.inArray(c,b.disabled)!=-1&&!d(i).hasClass("ui-tabs-selected")?"addClass":"removeClass"]("ui-state-disabled");b.cache===false&&this.anchors.removeData("cache.tabs");this.lis.add(this.anchors).unbind(".tabs");if(b.event!="mouseover"){var k=function(g,f){f.is(":not(.ui-state-disabled)")&&f.addClass("ui-state-"+g)},n=function(g,f){f.removeClass("ui-state-"+g)};this.lis.bind("mouseover.tabs",
function(){k("hover",d(this))});this.lis.bind("mouseout.tabs",function(){n("hover",d(this))});this.anchors.bind("focus.tabs",function(){k("focus",d(this).closest("li"))});this.anchors.bind("blur.tabs",function(){n("focus",d(this).closest("li"))})}var m,o;if(b.fx)if(d.isArray(b.fx)){m=b.fx[0];o=b.fx[1]}else m=o=b.fx;var q=o?function(g,f){d(g).closest("li").addClass("ui-tabs-selected ui-state-active");f.hide().removeClass("ui-tabs-hide").animate(o,o.duration||"normal",function(){e(f,o);a._trigger("show",
null,a._ui(g,f[0]))})}:function(g,f){d(g).closest("li").addClass("ui-tabs-selected ui-state-active");f.removeClass("ui-tabs-hide");a._trigger("show",null,a._ui(g,f[0]))},r=m?function(g,f){f.animate(m,m.duration||"normal",function(){a.lis.removeClass("ui-tabs-selected ui-state-active");f.addClass("ui-tabs-hide");e(f,m);a.element.dequeue("tabs")})}:function(g,f){a.lis.removeClass("ui-tabs-selected ui-state-active");f.addClass("ui-tabs-hide");a.element.dequeue("tabs")};this.anchors.bind(b.event+".tabs",
function(){var g=this,f=d(this).closest("li"),j=a.panels.filter(":not(.ui-tabs-hide)"),l=d(a._sanitizeSelector(this.hash));if(f.hasClass("ui-tabs-selected")&&!b.collapsible||f.hasClass("ui-state-disabled")||f.hasClass("ui-state-processing")||a._trigger("select",null,a._ui(this,l[0]))===false){this.blur();return false}b.selected=a.anchors.index(this);a.abort();if(b.collapsible)if(f.hasClass("ui-tabs-selected")){b.selected=-1;b.cookie&&a._cookie(b.selected,b.cookie);a.element.queue("tabs",function(){r(g,
j)}).dequeue("tabs");this.blur();return false}else if(!j.length){b.cookie&&a._cookie(b.selected,b.cookie);a.element.queue("tabs",function(){q(g,l)});a.load(a.anchors.index(this));this.blur();return false}b.cookie&&a._cookie(b.selected,b.cookie);if(l.length){j.length&&a.element.queue("tabs",function(){r(g,j)});a.element.queue("tabs",function(){q(g,l)});a.load(a.anchors.index(this))}else throw"jQuery UI Tabs: Mismatching fragment identifier.";d.browser.msie&&this.blur()});this.anchors.bind("click.tabs",
function(){return false})},destroy:function(){var c=this.options;this.abort();this.element.unbind(".tabs").removeClass("ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible").removeData("tabs");this.list.removeClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all");this.anchors.each(function(){var e=d.data(this,"href.tabs");if(e)this.href=e;var a=d(this).unbind(".tabs");d.each(["href","load","cache"],function(b,h){a.removeData(h+".tabs")})});this.lis.unbind(".tabs").add(this.panels).each(function(){d.data(this,
"destroy.tabs")?d(this).remove():d(this).removeClass("ui-state-default ui-corner-top ui-tabs-selected ui-state-active ui-state-hover ui-state-focus ui-state-disabled ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide")});c.cookie&&this._cookie(null,c.cookie);return this},add:function(c,e,a){if(a===undefined)a=this.anchors.length;var b=this,h=this.options;e=d(h.tabTemplate.replace(/#\{href\}/g,c).replace(/#\{label\}/g,e));c=!c.indexOf("#")?c.replace("#",""):this._tabId(d("a",e)[0]);e.addClass("ui-state-default ui-corner-top").data("destroy.tabs",
true);var i=d("#"+c);i.length||(i=d(h.panelTemplate).attr("id",c).data("destroy.tabs",true));i.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide");if(a>=this.lis.length){e.appendTo(this.list);i.appendTo(this.list[0].parentNode)}else{e.insertBefore(this.lis[a]);i.insertBefore(this.panels[a])}h.disabled=d.map(h.disabled,function(k){return k>=a?++k:k});this._tabify();if(this.anchors.length==1){h.selected=0;e.addClass("ui-tabs-selected ui-state-active");i.removeClass("ui-tabs-hide");
this.element.queue("tabs",function(){b._trigger("show",null,b._ui(b.anchors[0],b.panels[0]))});this.load(0)}this._trigger("add",null,this._ui(this.anchors[a],this.panels[a]));return this},remove:function(c){var e=this.options,a=this.lis.eq(c).remove(),b=this.panels.eq(c).remove();if(a.hasClass("ui-tabs-selected")&&this.anchors.length>1)this.select(c+(c+1<this.anchors.length?1:-1));e.disabled=d.map(d.grep(e.disabled,function(h){return h!=c}),function(h){return h>=c?--h:h});this._tabify();this._trigger("remove",
null,this._ui(a.find("a")[0],b[0]));return this},enable:function(c){var e=this.options;if(d.inArray(c,e.disabled)!=-1){this.lis.eq(c).removeClass("ui-state-disabled");e.disabled=d.grep(e.disabled,function(a){return a!=c});this._trigger("enable",null,this._ui(this.anchors[c],this.panels[c]));return this}},disable:function(c){var e=this.options;if(c!=e.selected){this.lis.eq(c).addClass("ui-state-disabled");e.disabled.push(c);e.disabled.sort();this._trigger("disable",null,this._ui(this.anchors[c],this.panels[c]))}return this},
select:function(c){if(typeof c=="string")c=this.anchors.index(this.anchors.filter("[href$="+c+"]"));else if(c===null)c=-1;if(c==-1&&this.options.collapsible)c=this.options.selected;this.anchors.eq(c).trigger(this.options.event+".tabs");return this},load:function(c){var e=this,a=this.options,b=this.anchors.eq(c)[0],h=d.data(b,"load.tabs");this.abort();if(!h||this.element.queue("tabs").length!==0&&d.data(b,"cache.tabs"))this.element.dequeue("tabs");else{this.lis.eq(c).addClass("ui-state-processing");
if(a.spinner){var i=d("span",b);i.data("label.tabs",i.html()).html(a.spinner)}this.xhr=d.ajax(d.extend({},a.ajaxOptions,{url:h,success:function(k,n){d(e._sanitizeSelector(b.hash)).html(k);e._cleanup();a.cache&&d.data(b,"cache.tabs",true);e._trigger("load",null,e._ui(e.anchors[c],e.panels[c]));try{a.ajaxOptions.success(k,n)}catch(m){}},error:function(k,n){e._cleanup();e._trigger("load",null,e._ui(e.anchors[c],e.panels[c]));try{a.ajaxOptions.error(k,n,c,b)}catch(m){}}}));e.element.dequeue("tabs");return this}},
abort:function(){this.element.queue([]);this.panels.stop(false,true);this.element.queue("tabs",this.element.queue("tabs").splice(-2,2));if(this.xhr){this.xhr.abort();delete this.xhr}this._cleanup();return this},url:function(c,e){this.anchors.eq(c).removeData("cache.tabs").data("load.tabs",e);return this},length:function(){return this.anchors.length}});d.extend(d.ui.tabs,{version:"1.8.1"});d.extend(d.ui.tabs.prototype,{rotation:null,rotate:function(c,e){var a=this,b=this.options,h=a._rotate||(a._rotate=
function(i){clearTimeout(a.rotation);a.rotation=setTimeout(function(){var k=b.selected;a.select(++k<a.anchors.length?k:0)},c);i&&i.stopPropagation()});e=a._unrotate||(a._unrotate=!e?function(i){i.clientX&&a.rotate(null)}:function(){t=b.selected;h()});if(c){this.element.bind("tabsshow",h);this.anchors.bind(b.event+".tabs",e);h()}else{clearTimeout(a.rotation);this.element.unbind("tabsshow",h);this.anchors.unbind(b.event+".tabs",e);delete this._rotate;delete this._unrotate}return this}})})(jQuery);

/**
 * jQuery UI Effects 1.8.1
 *
 * Copyright (c) 2010 AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * http://docs.jquery.com/UI/Effects/
 */
jQuery.effects||function(f){function k(c){var a;if(c&&c.constructor==Array&&c.length==3)return c;if(a=/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(c))return[parseInt(a[1],10),parseInt(a[2],10),parseInt(a[3],10)];if(a=/rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(c))return[parseFloat(a[1])*2.55,parseFloat(a[2])*2.55,parseFloat(a[3])*2.55];if(a=/#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(c))return[parseInt(a[1],
16),parseInt(a[2],16),parseInt(a[3],16)];if(a=/#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(c))return[parseInt(a[1]+a[1],16),parseInt(a[2]+a[2],16),parseInt(a[3]+a[3],16)];if(/rgba\(0, 0, 0, 0\)/.exec(c))return l.transparent;return l[f.trim(c).toLowerCase()]}function q(c,a){var b;do{b=f.curCSS(c,a);if(b!=""&&b!="transparent"||f.nodeName(c,"body"))break;a="backgroundColor"}while(c=c.parentNode);return k(b)}function m(){var c=document.defaultView?document.defaultView.getComputedStyle(this,null):this.currentStyle,
a={},b,d;if(c&&c.length&&c[0]&&c[c[0]])for(var e=c.length;e--;){b=c[e];if(typeof c[b]=="string"){d=b.replace(/\-(\w)/g,function(g,h){return h.toUpperCase()});a[d]=c[b]}}else for(b in c)if(typeof c[b]==="string")a[b]=c[b];return a}function n(c){var a,b;for(a in c){b=c[a];if(b==null||f.isFunction(b)||a in r||/scrollbar/.test(a)||!/color/i.test(a)&&isNaN(parseFloat(b)))delete c[a]}return c}function s(c,a){var b={_:0},d;for(d in a)if(c[d]!=a[d])b[d]=a[d];return b}function j(c,a,b,d){if(typeof c=="object"){d=
a;b=null;a=c;c=a.effect}if(f.isFunction(a)){d=a;b=null;a={}}if(f.isFunction(b)){d=b;b=null}if(typeof a=="number"||f.fx.speeds[a]){d=b;b=a;a={}}a=a||{};b=b||a.duration;b=f.fx.off?0:typeof b=="number"?b:f.fx.speeds[b]||f.fx.speeds._default;d=d||a.complete;return[c,a,b,d]}f.effects={};f.each(["backgroundColor","borderBottomColor","borderLeftColor","borderRightColor","borderTopColor","color","outlineColor"],function(c,a){f.fx.step[a]=function(b){if(!b.colorInit){b.start=q(b.elem,a);b.end=k(b.end);b.colorInit=
true}b.elem.style[a]="rgb("+Math.max(Math.min(parseInt(b.pos*(b.end[0]-b.start[0])+b.start[0],10),255),0)+","+Math.max(Math.min(parseInt(b.pos*(b.end[1]-b.start[1])+b.start[1],10),255),0)+","+Math.max(Math.min(parseInt(b.pos*(b.end[2]-b.start[2])+b.start[2],10),255),0)+")"}});var l={aqua:[0,255,255],azure:[240,255,255],beige:[245,245,220],black:[0,0,0],blue:[0,0,255],brown:[165,42,42],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgrey:[169,169,169],darkgreen:[0,100,0],darkkhaki:[189,
183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkviolet:[148,0,211],fuchsia:[255,0,255],gold:[255,215,0],green:[0,128,0],indigo:[75,0,130],khaki:[240,230,140],lightblue:[173,216,230],lightcyan:[224,255,255],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightyellow:[255,255,224],lime:[0,255,0],magenta:[255,0,255],maroon:[128,0,0],navy:[0,0,128],olive:[128,128,0],orange:[255,
165,0],pink:[255,192,203],purple:[128,0,128],violet:[128,0,128],red:[255,0,0],silver:[192,192,192],white:[255,255,255],yellow:[255,255,0],transparent:[255,255,255]},o=["add","remove","toggle"],r={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1};f.effects.animateClass=function(c,a,b,d){if(f.isFunction(b)){d=b;b=null}return this.each(function(){var e=f(this),g=e.attr("style")||" ",h=n(m.call(this)),p,t=e.attr("className");f.each(o,function(u,
i){c[i]&&e[i+"Class"](c[i])});p=n(m.call(this));e.attr("className",t);e.animate(s(h,p),a,b,function(){f.each(o,function(u,i){c[i]&&e[i+"Class"](c[i])});if(typeof e.attr("style")=="object"){e.attr("style").cssText="";e.attr("style").cssText=g}else e.attr("style",g);d&&d.apply(this,arguments)})})};f.fn.extend({_addClass:f.fn.addClass,addClass:function(c,a,b,d){return a?f.effects.animateClass.apply(this,[{add:c},a,b,d]):this._addClass(c)},_removeClass:f.fn.removeClass,removeClass:function(c,a,b,d){return a?
f.effects.animateClass.apply(this,[{remove:c},a,b,d]):this._removeClass(c)},_toggleClass:f.fn.toggleClass,toggleClass:function(c,a,b,d,e){return typeof a=="boolean"||a===undefined?b?f.effects.animateClass.apply(this,[a?{add:c}:{remove:c},b,d,e]):this._toggleClass(c,a):f.effects.animateClass.apply(this,[{toggle:c},a,b,d])},switchClass:function(c,a,b,d,e){return f.effects.animateClass.apply(this,[{add:a,remove:c},b,d,e])}});f.extend(f.effects,{version:"1.8.1",save:function(c,a){for(var b=0;b<a.length;b++)a[b]!==
null&&c.data("ec.storage."+a[b],c[0].style[a[b]])},restore:function(c,a){for(var b=0;b<a.length;b++)a[b]!==null&&c.css(a[b],c.data("ec.storage."+a[b]))},setMode:function(c,a){if(a=="toggle")a=c.is(":hidden")?"show":"hide";return a},getBaseline:function(c,a){var b;switch(c[0]){case "top":b=0;break;case "middle":b=0.5;break;case "bottom":b=1;break;default:b=c[0]/a.height}switch(c[1]){case "left":c=0;break;case "center":c=0.5;break;case "right":c=1;break;default:c=c[1]/a.width}return{x:c,y:b}},createWrapper:function(c){if(c.parent().is(".ui-effects-wrapper"))return c.parent();
var a={width:c.outerWidth(true),height:c.outerHeight(true),"float":c.css("float")},b=f("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0});c.wrap(b);b=c.parent();if(c.css("position")=="static"){b.css({position:"relative"});c.css({position:"relative"})}else{f.extend(a,{position:c.css("position"),zIndex:c.css("z-index")});f.each(["top","left","bottom","right"],function(d,e){a[e]=c.css(e);if(isNaN(parseInt(a[e],10)))a[e]="auto"});
c.css({position:"relative",top:0,left:0})}return b.css(a).show()},removeWrapper:function(c){if(c.parent().is(".ui-effects-wrapper"))return c.parent().replaceWith(c);return c},setTransition:function(c,a,b,d){d=d||{};f.each(a,function(e,g){unit=c.cssUnit(g);if(unit[0]>0)d[g]=unit[0]*b+unit[1]});return d}});f.fn.extend({effect:function(c){var a=j.apply(this,arguments);a={options:a[1],duration:a[2],callback:a[3]};var b=f.effects[c];return b&&!f.fx.off?b.call(this,a):this},_show:f.fn.show,show:function(c){if(!c||
typeof c=="number"||f.fx.speeds[c])return this._show.apply(this,arguments);else{var a=j.apply(this,arguments);a[1].mode="show";return this.effect.apply(this,a)}},_hide:f.fn.hide,hide:function(c){if(!c||typeof c=="number"||f.fx.speeds[c])return this._hide.apply(this,arguments);else{var a=j.apply(this,arguments);a[1].mode="hide";return this.effect.apply(this,a)}},__toggle:f.fn.toggle,toggle:function(c){if(!c||typeof c=="number"||f.fx.speeds[c]||typeof c=="boolean"||f.isFunction(c))return this.__toggle.apply(this,
arguments);else{var a=j.apply(this,arguments);a[1].mode="toggle";return this.effect.apply(this,a)}},cssUnit:function(c){var a=this.css(c),b=[];f.each(["em","px","%","pt"],function(d,e){if(a.indexOf(e)>0)b=[parseFloat(a),e]});return b}});f.easing.jswing=f.easing.swing;f.extend(f.easing,{def:"easeOutQuad",swing:function(c,a,b,d,e){return f.easing[f.easing.def](c,a,b,d,e)},easeInQuad:function(c,a,b,d,e){return d*(a/=e)*a+b},easeOutQuad:function(c,a,b,d,e){return-d*(a/=e)*(a-2)+b},easeInOutQuad:function(c,
a,b,d,e){if((a/=e/2)<1)return d/2*a*a+b;return-d/2*(--a*(a-2)-1)+b},easeInCubic:function(c,a,b,d,e){return d*(a/=e)*a*a+b},easeOutCubic:function(c,a,b,d,e){return d*((a=a/e-1)*a*a+1)+b},easeInOutCubic:function(c,a,b,d,e){if((a/=e/2)<1)return d/2*a*a*a+b;return d/2*((a-=2)*a*a+2)+b},easeInQuart:function(c,a,b,d,e){return d*(a/=e)*a*a*a+b},easeOutQuart:function(c,a,b,d,e){return-d*((a=a/e-1)*a*a*a-1)+b},easeInOutQuart:function(c,a,b,d,e){if((a/=e/2)<1)return d/2*a*a*a*a+b;return-d/2*((a-=2)*a*a*a-2)+
b},easeInQuint:function(c,a,b,d,e){return d*(a/=e)*a*a*a*a+b},easeOutQuint:function(c,a,b,d,e){return d*((a=a/e-1)*a*a*a*a+1)+b},easeInOutQuint:function(c,a,b,d,e){if((a/=e/2)<1)return d/2*a*a*a*a*a+b;return d/2*((a-=2)*a*a*a*a+2)+b},easeInSine:function(c,a,b,d,e){return-d*Math.cos(a/e*(Math.PI/2))+d+b},easeOutSine:function(c,a,b,d,e){return d*Math.sin(a/e*(Math.PI/2))+b},easeInOutSine:function(c,a,b,d,e){return-d/2*(Math.cos(Math.PI*a/e)-1)+b},easeInExpo:function(c,a,b,d,e){return a==0?b:d*Math.pow(2,
10*(a/e-1))+b},easeOutExpo:function(c,a,b,d,e){return a==e?b+d:d*(-Math.pow(2,-10*a/e)+1)+b},easeInOutExpo:function(c,a,b,d,e){if(a==0)return b;if(a==e)return b+d;if((a/=e/2)<1)return d/2*Math.pow(2,10*(a-1))+b;return d/2*(-Math.pow(2,-10*--a)+2)+b},easeInCirc:function(c,a,b,d,e){return-d*(Math.sqrt(1-(a/=e)*a)-1)+b},easeOutCirc:function(c,a,b,d,e){return d*Math.sqrt(1-(a=a/e-1)*a)+b},easeInOutCirc:function(c,a,b,d,e){if((a/=e/2)<1)return-d/2*(Math.sqrt(1-a*a)-1)+b;return d/2*(Math.sqrt(1-(a-=2)*
a)+1)+b},easeInElastic:function(c,a,b,d,e){c=1.70158;var g=0,h=d;if(a==0)return b;if((a/=e)==1)return b+d;g||(g=e*0.3);if(h<Math.abs(d)){h=d;c=g/4}else c=g/(2*Math.PI)*Math.asin(d/h);return-(h*Math.pow(2,10*(a-=1))*Math.sin((a*e-c)*2*Math.PI/g))+b},easeOutElastic:function(c,a,b,d,e){c=1.70158;var g=0,h=d;if(a==0)return b;if((a/=e)==1)return b+d;g||(g=e*0.3);if(h<Math.abs(d)){h=d;c=g/4}else c=g/(2*Math.PI)*Math.asin(d/h);return h*Math.pow(2,-10*a)*Math.sin((a*e-c)*2*Math.PI/g)+d+b},easeInOutElastic:function(c,
a,b,d,e){c=1.70158;var g=0,h=d;if(a==0)return b;if((a/=e/2)==2)return b+d;g||(g=e*0.3*1.5);if(h<Math.abs(d)){h=d;c=g/4}else c=g/(2*Math.PI)*Math.asin(d/h);if(a<1)return-0.5*h*Math.pow(2,10*(a-=1))*Math.sin((a*e-c)*2*Math.PI/g)+b;return h*Math.pow(2,-10*(a-=1))*Math.sin((a*e-c)*2*Math.PI/g)*0.5+d+b},easeInBack:function(c,a,b,d,e,g){if(g==undefined)g=1.70158;return d*(a/=e)*a*((g+1)*a-g)+b},easeOutBack:function(c,a,b,d,e,g){if(g==undefined)g=1.70158;return d*((a=a/e-1)*a*((g+1)*a+g)+1)+b},easeInOutBack:function(c,
a,b,d,e,g){if(g==undefined)g=1.70158;if((a/=e/2)<1)return d/2*a*a*(((g*=1.525)+1)*a-g)+b;return d/2*((a-=2)*a*(((g*=1.525)+1)*a+g)+2)+b},easeInBounce:function(c,a,b,d,e){return d-f.easing.easeOutBounce(c,e-a,0,d,e)+b},easeOutBounce:function(c,a,b,d,e){return(a/=e)<1/2.75?d*7.5625*a*a+b:a<2/2.75?d*(7.5625*(a-=1.5/2.75)*a+0.75)+b:a<2.5/2.75?d*(7.5625*(a-=2.25/2.75)*a+0.9375)+b:d*(7.5625*(a-=2.625/2.75)*a+0.984375)+b},easeInOutBounce:function(c,a,b,d,e){if(a<e/2)return f.easing.easeInBounce(c,a*2,0,
d,e)*0.5+b;return f.easing.easeOutBounce(c,a*2-e,0,d,e)*0.5+d*0.5+b}})}(jQuery);

/*
 * jQuery UI Effects Slide 1.8.1
 *
 * Copyright (c) 2010 AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * http://docs.jquery.com/UI/Effects/Slide
 *
 * Depends:
 *	jquery.effects.core.js
 */
(function(c){c.effects.slide=function(d){return this.queue(function(){var a=c(this),h=["position","top","left"],e=c.effects.setMode(a,d.options.mode||"show"),b=d.options.direction||"left";c.effects.save(a,h);a.show();c.effects.createWrapper(a).css({overflow:"hidden"});var f=b=="up"||b=="down"?"top":"left";b=b=="up"||b=="left"?"pos":"neg";var g=d.options.distance||(f=="top"?a.outerHeight({margin:true}):a.outerWidth({margin:true}));if(e=="show")a.css(f,b=="pos"?-g:g);var i={};i[f]=(e=="show"?b=="pos"?
"+=":"-=":b=="pos"?"-=":"+=")+g;a.animate(i,{queue:false,duration:d.duration,easing:d.options.easing,complete:function(){e=="hide"&&a.hide();c.effects.restore(a,h);c.effects.removeWrapper(a);d.callback&&d.callback.apply(this,arguments);a.dequeue()}})})}})(jQuery);

/**
	Slimbox v2.03 - The ultimate lightweight Lightbox clone for jQuery
	(c) 2007-2009 Christophe Beyls <http://www.digitalia.be>
	MIT-style license.
	
	Modified by Shopware AG 2010
	@author: S.Pohl <info@shopware.de>
	@date: 25-04-2010
	@version: 1.1
	
	changelog
	- removes caption
	- new close button
	- new overlay image
*/
(function ($) {
    var win = $(window),
        options, images, activeImage = -1,
        activeThumb, prevThumb, startThumb, single, activeURL, prevImage, nextImage, compatibleOverlay, middle, centerWidth, centerHeight, ie6 = !window.XMLHttpRequest,
        video, operaFix = window.opera && (document.compatMode == "CSS1Compat") && ($.browser.version >= 9.3),
        documentElement = document.documentElement,
        preload = {},
        preloadPrev = new Image(),
        preloadNext = new Image(),
        overlay, center, image, thumbs, closer, sizer, prevLink, nextLink, bottomContainer, bottom, caption, number;
    $(function () {
        $("body").append($([overlay = $('<div id="lbOverlay" />').click(close)[0], center = $('<div id="lbCenter" />')[0], bottomContainer = $('<div id="lbBottomContainer" />')[0], closer = $('<div id="lbCloser" />').click(close)[0], ]).css("display", "none"));
        image = $('<div id="lbImage" />').appendTo(center).click(close).append(sizer = $('<div style="position: relative;" />').append([prevLink = $('<a id="lbPrevLink" href="#" />').click(previous)[0], nextLink = $('<a id="lbNextLink" href="#" />').click(next)[0]])[0])[0];
        thumbs = $('<div id="lbThumbs" />').appendTo(center);
        $('#lbImage').css('cursor', 'pointer');
    });
    $.slimbox = function (_images, startImage, thumbList, video, _options) {
        options = $.extend({
            loop: false,
            overlayOpacity: 0.3,
            overlayFadeDuration: 400,
            resizeDuration: 400,
            resizeEasing: "swing",
            initialWidth: 250,
            initialHeight: 250,
            imageFadeDuration: 600,
            captionAnimationDuration: 200,
            counterText: "Bild {x} von {y}",
            closeKeys: [27, 88, 67],
            previousKeys: [37, 80],
            nextKeys: [39, 78]
        }, _options);
        single = false;
        if (typeof _images[3] == 'undefined') {
            single = true
        }
        if (typeof _images == "string") {
            _images = [
                [_images, startImage]
            ];
            startImage = 0
        }
        if (!single) {
            $.each(thumbList, function (i, el) {
                var thumbimg = $('<img>', {
                    src: el,
                    index: i
                }).click(function () {
                    if (startThumb.hasClass('active')) startThumb.removeClass('active');
                    if (activeThumb) activeThumb.removeClass('active');
                    changeImage(i);
                    $(this).addClass('active');
                    activeThumb = $(this)
                });
                if (i == startImage) {
                    thumbimg.addClass('active');
                    startThumb = thumbimg
                }
                var a = $('<a>', {
                    html: thumbimg
                }).appendTo(thumbs)
            })
        }
        middle = win.scrollTop() + ((operaFix ? documentElement.clientHeight : win.height()) / 2);
        centerWidth = options.initialWidth;
        centerHeight = options.initialHeight;
        $(center).css({
            top: Math.max(0, middle - (centerHeight / 2)),
            width: centerWidth,
            height: centerHeight,
            marginLeft: -centerWidth / 2
        }).show();
        /* compatibleOverlay = ie6 || (overlay.currentStyle && (overlay.currentStyle.position != "fixed"));
        if (compatibleOverlay) overlay.style.position = "absolute";*/
        $(overlay).css("opacity", options.overlayOpacity).fadeIn(options.overlayFadeDuration);
        position();
        setup(1);
        images = _images;
        options.loop = options.loop && (images.length > 1);
        return changeImage(startImage)
    };
    $.fn.slimbox = function (_options, linkMapper, linksFilter) {
        linkMapper = linkMapper ||
        function (el) {
            return [el.href, el.title]
        };
        linksFilter = linksFilter ||
        function () {
            return true
        };
        var thumbList = {};
        var links = this;
        return links.unbind("click").click(function () {
            var link = this,
                startIndex = 0,
                filteredLinks, i = 0,
                length;
            filteredLinks = $.grep(links, function (el, i) {
                return linksFilter.call(link, el, i)
            });
            thumbList = {};
            video = {};
            $.each(filteredLinks, function (i, el) {
                if ($(el).children('img').length) {
                    thumbList[i] = $(el).children('img').attr('src')
                } else {
                    var _img = $(el).css('background-image').split('"');
                    thumbList[i] = _img[1]
                }
            });
            for (length = filteredLinks.length; i < length; ++i) {
                if (filteredLinks[i] == link) startIndex = i;
                filteredLinks[i] = linkMapper(filteredLinks[i], i)
            }
            return $.slimbox(filteredLinks, startIndex, thumbList, _options)
        })
    };

    function position() {
        var l = win.scrollLeft(),
            w = operaFix ? documentElement.clientWidth : win.width();
        $([center, bottomContainer, closer]).css("left", l + (w / 2));
        if (compatibleOverlay) $(overlay).css({
            left: l,
            top: win.scrollTop(),
            width: w,
            height: win.height()
        })
    }
    function setup(open) {
        /*$("object").add(ie6 ? "select" : "embed").each(function (index, el) {
            if (open) $.data(el, "slimbox", el.style.visibility);
            el.style.visibility = open ? "hidden" : $.data(el, "slimbox")
        }); */
        var fn = open ? "bind" : "unbind";
        win[fn]("scroll resize", position);
    }
    function previous() {
        return changeImage(prevImage)
    }
    function next() {
        return changeImage(nextImage)
    }
    function changeImage(imageIndex) {
        if (imageIndex >= 0) {
            $('#lbThumbs a img[index=' + imageIndex + ']').addClass('active');
            if (prevThumb) prevThumb.removeClass('active');
            prevThumb = $('#lbThumbs a img[index=' + imageIndex + ']');
            activeImage = imageIndex;
            activeURL = images[activeImage][0];
            prevImage = (activeImage || (options.loop ? images.length : 0)) - 1;
            nextImage = ((activeImage + 1) % images.length) || (options.loop ? 0 : -1);
            stop();
            center.className = "lbLoading";
            if ($.isEmptyObject(video)) {
                preload = new Image();
                preload.onload = animateBox;
                preload.src = activeURL
            } else {
                animateBox()
            }
        }
        return false
    }
    function animateBox() {
        center.className = "";
        if ($.isEmptyObject(video)) {
            $(image).css({
                backgroundImage: "url(" + activeURL + ")",
                visibility: "hidden",
                display: ""
            });
            $(sizer).width(preload.width);
            $([sizer, prevLink, nextLink]).height(preload.height)
        }
        $(caption).html(images[activeImage][1] || "");
        $(number).html((((images.length > 1) && options.counterText) || "").replace(/{x}/, activeImage + 1).replace(/{y}/, images.length));
        if (prevImage >= 0) preloadPrev.src = images[prevImage][0];
        if (nextImage >= 0) preloadNext.src = images[nextImage][0];
        centerWidth = image.offsetWidth;
        centerHeight = image.offsetHeight;
        if (!$.isEmptyObject(video)) {
            centerHeight = 500;
            centerWidth = 660;
            var div = $('<div>', {
                'id': 'player',
                'href': $(video[0][0]).attr('href'),
                'css': {
                    'height': centerHeight - 20,
                    'width': centerWidth - 20
                }
            }).appendTo($(image));
            flowplayer('player', 'video/flowplayer-3.1.5.swf')
        }
        var top = Math.max(0, middle - (centerHeight / 2));
        if (center.offsetHeight != centerHeight) {
            $(center).animate({
                'height': centerHeight,
                'top': top
            }, options.resizeDuration, options.resizeEasing)
        }
        if (center.offsetWidth != centerWidth) {
            $(center).animate({
                'width': centerWidth,
                'marginLeft': -(centerWidth / 2)
            }, options.resizeDuration, options.resizeEasing)
        }
        $(center).queue(function () {
            $(image).hide().css('visibility', 'visible').fadeIn(options.imageFadeDuration, animateCaption)
        });
        centerWidth = centerWidth / 2;
        $(closer).css({
		    'top': top,
		    'marginLeft': centerWidth - 11
		});

        
        //Hide Prev and Next picture link
         $.ie6fix.selectHide();
    }
    function animateCaption() {
        $(closer).show();
    }
    function stop() {
        preload.onload = null;
        preload.src = preloadPrev.src = preloadNext.src = activeURL;
        $([center, image, bottom]).stop(true);
        $([prevLink, nextLink, image, bottomContainer, closer]).hide()
        $.ie6fix.selectShow();
    }
    function close() {

        if (activeImage >= 0) {
            stop();
            $(thumbs).empty();
            $('#player').remove();
            activeImage = prevImage = nextImage = -1;
            $(center).hide();
            $(overlay).stop().fadeOut(options.overlayFadeDuration, setup)
        }
        $.ie6fix.selectShow();
        return false
    }
})(jQuery);

//////////////////////////////////////////////////////////////////////////////////
// Cloud Zoom V1.0.2
// (c) 2010 by R Cecco. <http://www.professorcloud.com>
// MIT License
//
// Please retain this copyright header in all versions of the software
//////////////////////////////////////////////////////////////////////////////////
(function ($) {

    $(document).ready(function () {
        $('.cloud-zoom, .cloud-zoom-gallery').CloudZoom();
    });

    function CloudZoom(jWin, opts) {
        var sImg = $('img', jWin);
		var	img1;
		var	img2;
        var zoomDiv = null;
		var	$mouseTrap = null;
		var	lens = null;
		var	$tint = null;
		var	softFocus = null;
		var	$ie6Fix = null;
		var	zoomImage;
        var controlTimer = 0;      
        var cw, ch;
        var destU = 0;
		var	destV = 0;
        var currV = 0;
        var currU = 0;      
        var filesLoaded = 0;
        var mx,
            my; 
        var ctx = this, zw;
        
        // Display an image loading message. This message gets deleted when the images have loaded and the zoom init function is called.
        // We add a small delay before the message is displayed to avoid the message flicking on then off again virtually immediately if the
        // images load really fast, e.g. from the cache. 
        //var	ctx = this;
        setTimeout(function () {
            if ($mouseTrap === null) {
                var w = jWin.width();
                jWin.parent().append($.format('<div style="width:%0px;position:absolute;top:75%;left:%1px;text-align:center" class="cloud-zoom-loading" >Loading...</div>', w / 3, (w / 2) - (w / 6))).find(':last').css('opacity', 0.5);
            }
        }, 200);


        var ie6FixRemove = function () {
			
            if ($ie6Fix !== null) {
                $ie6Fix.remove();
                $ie6Fix = null;
            }
        };

        // Removes cursor, tint layer, blur layer etc.
        this.removeBits = function () {
            if (lens) {
                lens.remove();
                lens = null;             
            }
            if ($tint) {
                $tint.remove();
                $tint = null;
            }
            if (softFocus) {
                softFocus.remove();
                softFocus = null;
            }
           	ie6FixRemove();

            $('.cloud-zoom-loading', jWin.parent()).remove();
        };

		
		
        this.destroy = function () {
            jWin.data('zoom', null);

            if ($mouseTrap) {
                $mouseTrap.unbind();
                $mouseTrap.remove();
                $mouseTrap = null;
            }
            if (zoomDiv) {
                zoomDiv.remove();
                zoomDiv = null;
            }
           	//ie6FixRemove();
            this.removeBits();
            // DON'T FORGET TO REMOVE JQUERY 'DATA' VALUES
        };


        // This is called when the zoom window has faded out so it can be removed.
        this.fadedOut = function () {
            
			if (zoomDiv) {
                zoomDiv.remove();
                zoomDiv = null;
            }
			 this.removeBits();
             ie6FixRemove();
        };

        this.controlLoop = function () {
            if (lens) {
                var x = (mx - sImg.offset().left - (cw * 0.5)) >> 0;
                var y = (my - sImg.offset().top - (ch * 0.5)) >> 0;
               
                if (x < 0) {
                    x = 0;
                }
                else if (x > (sImg.outerWidth() - cw)) {
                    x = (sImg.outerWidth() - cw);
                }
                if (y < 0) {
                    y = 0;
                }
                else if (y > (sImg.outerHeight() - ch)) {
                    y = (sImg.outerHeight() - ch);
                }

                lens.css({
                    left: x,
                    top: y
                });
                lens.css('background-position', (-x) + 'px ' + (-y) + 'px');

                destU = (((x) / sImg.outerWidth()) * zoomImage.width) >> 0;
                destV = (((y) / sImg.outerHeight()) * zoomImage.height) >> 0;
                currU += (destU - currU) / opts.smoothMove;
                currV += (destV - currV) / opts.smoothMove;

                zoomDiv.css('background-position', (-(currU >> 0) + 'px ') + (-(currV >> 0) + 'px'));              
            }
            controlTimer = setTimeout(function () {
                ctx.controlLoop();
            }, 30);
        };

        this.init2 = function (img, id) {
			
			var wrap = $('#wrap');
            var wrapimg = $('#zoom1 img');
            
            $('#wrap').css('width', wrapimg.innerWidth());
			
            filesLoaded++;
            if (id === 1) {
                zoomImage = img;
            }
            
            //this.images[id] = img;
            if (filesLoaded === 2) {
        
      			//wrap.css('width', wrapimg.outerWidth());
            	
                this.init();
            }
        };

        /* Init function start.  */
        this.init = function () {
            // Remove loading message (if present);
            $('.cloud-zoom-loading', jWin.parent()).remove();


		/* Add a box (mouseTrap) over the small image to trap mouse events.
		It has priority over zoom window to avoid issues with inner zoom.
		We need the dummy background image as IE does not trap mouse events on
		transparent parts of a div.
		*/
            $mouseTrap = jWin.parent().append($.format("<div class='mousetrap' style='z-index:999;position:absolute;width:%0px;height:%1px;left:%2px;top:%3px;\'></div>", sImg.outerWidth(), sImg.outerHeight(), 0, 0)).find(':last');
			
			if ($.browser.msie && parseInt($.browser.version) < 10) {
				$mouseTrap.css('background', 'url(".")');
			}
			
			$mouseTrap.bind('click', this, function (event) {
                $(this).prev().addClass('startimage');
                var relEl = $("a[rel^='" + $(this).prev().attr('rel') + "']");
                var images = [];
                var thumblist = {};
                var video = {};
                var startImage = 0;
                $.each(relEl, function (i, el) {
                    if ($(el).hasClass('startimage')) {
                        startImage = i
                    }
                    images[i] = [$(el).attr('href')];
                    if ($(el).children('img').attr('src')) {
                        thumblist[i] = $(el).children('img').attr('src')
                    } else {
                        thumblist[i] = $(el).attr('href')
                    }
                });
                $.slimbox(images, startImage, thumblist, video)
            });

			
            //////////////////////////////////////////////////////////////////////			
            /* Do as little as possible in mousemove event to prevent slowdown. */
            $mouseTrap.bind('mousemove', this, function (event) {
                // Just update the mouse position
                mx = event.pageX;
                my = event.pageY;
            });
            //////////////////////////////////////////////////////////////////////					
            $mouseTrap.bind('mouseleave', this, function (event) {
            	
                clearTimeout(controlTimer);
                //event.data.removeBits();                
				if(lens) { lens.fadeOut(299); }
				if($tint) { $tint.fadeOut(299); }
				if(softFocus) { softFocus.fadeOut(299); }
				
				zoomDiv.fadeOut(300, function () {
                    ctx.fadedOut();
                });			
                $.ie6fix.selectShow();													
                return false;
            });
            //////////////////////////////////////////////////////////////////////			
            $mouseTrap.bind('mouseenter', this, function (event) {
            
            	$.ie6fix.selectHide();
            		
				mx = event.pageX;
                my = event.pageY;
                zw = event.data;
                if (zoomDiv) {
                    zoomDiv.stop(true, false);
                    zoomDiv.remove();
                }

                var xPos = opts.adjustX,
                    yPos = opts.adjustY;
                             
                var siw = sImg.outerWidth();
                var sih = sImg.outerHeight();

                var w = opts.zoomWidth;
                var h = opts.zoomHeight;
                if (opts.zoomWidth == 'auto') {
                    w = siw;
                }
                if (opts.zoomHeight == 'auto') {
                    h = sih;
                }
                //$('#info').text( xPos + ' ' + yPos + ' ' + siw + ' ' + sih );
                var appendTo = jWin.parent(); // attach to the wrapper			
                switch (opts.position) {
                case 'top':
                    yPos -= h; // + opts.adjustY;
                    break;
                case 'right':
                    xPos += siw; // + opts.adjustX;					
                    break;
                case 'bottom':
                    yPos += sih; // + opts.adjustY;
                    break;
                case 'left':
                    xPos -= w; // + opts.adjustX;					
                    break;
                case 'inside':
                    w = siw;
                    h = sih;
                    break;
                    // All other values, try and find an id in the dom to attach to.
                default:
                    appendTo = $('#' + opts.position);
                    // If dom element doesn't exit, just use 'right' position as default.
                    if (!appendTo.length) {
                        appendTo = jWin;
                        xPos += siw; //+ opts.adjustX;
                        yPos += sih; // + opts.adjustY;	
                    } else {
                        w = appendTo.innerWidth();
                        h = appendTo.innerHeight();
                    }
                }
               	var pos = appendTo.offset();
				zoomDiv = $(document.body).append($.format('<div id="cloud-zoom-big" class="cloud-zoom-big" style="display:none;position:absolute;left:%0px;top:%1px;width:%2px;height:%3px;background-image:url(\'%4\');z-index:99;"></div>', pos.left + sImg.width() + 15, pos.top - 4, w, h, zoomImage.src)).find(':last');

                // Add the title from title tag.
                if (sImg.attr('title') && opts.showTitle) {
                    zoomDiv.append($.format('<div class="cloud-zoom-title">%0</div>', sImg.attr('title'))).find(':last').css('opacity', opts.titleOpacity);
                }
                
                /* Work out size of cursor */
                cw = (sImg.outerWidth() / zoomImage.width) * zoomDiv.width();
                ch = (sImg.outerHeight() / zoomImage.height) * zoomDiv.height();
                
                // if the zoom is larger than the actual picture
                if(cw > sImg.outerWidth()) {
                	cw = sImg.outerWidth();
                	zoomDiv.width(zoomImage.width); 
                }
				
				zoomDiv.fadeIn(500);
				
            	 if (lens) {
                    lens.remove();
                    lens = null;
                }

                // Attach mouse, initially invisible to prevent first frame glitch
                lens = jWin.append($.format("<div class='cloud-zoom-lens' style='display:none;z-index:98;position:absolute;width:%0px;height:%1px;'></div>", cw, ch)).find(':last').fadeTo(200, 0.4);
                

                $mouseTrap.css('cursor', lens.css('cursor'));

                var noTrans = false;

                // Init tint layer if needed. (Not relevant if using inside mode)			
                if (opts.tint) {
                    lens.css('background', 'url("' + sImg.attr('src') + '")');
                    $tint = jWin.append($.format('<div style="display:none;position:absolute; left:0px; top:0px; width:%0px; height:%1px; background-color:%2;" />', sImg.outerWidth(), sImg.outerHeight(), opts.tint)).find(':last');
                    $tint.css('opacity', opts.tintOpacity);                    
					noTrans = true;
					$tint.fadeIn(500);

                }
                if (opts.softFocus) {
                    lens.css('background', 'url("' + sImg.attr('src') + '")');
                    softFocus = jWin.append($.format('<div style="position:absolute;display:none;top:2px; left:2px; width:%0px; height:%1px;" />', sImg.outerWidth() - 2, sImg.outerHeight() - 2, opts.tint)).find(':last');
                    softFocus.css('background', 'url("' + sImg.attr('src') + '")');
                    softFocus.css('opacity', 0.5);
                    noTrans = true;
                    softFocus.fadeIn(500);
                }

                /*if (!noTrans) {
                    lens.css('opacity', opts.lensOpacity); // opacity for all modern browsers
                    if ($.browser.msie && parseInt($.browser.version) > 6) {
                    	lens.css('-ms-filter', '"progid:DXImageTransform.Microsoft.Alpha(Opacity=50)"'); // opacity for ie 8
                    } else {
                    	lens.css('filter', 'alpha(opacity=50)'); // opacity for ie 6-7
                    }								
                }*/
				if ( opts.position !== 'inside' ) {
					lens.fadeIn(200);
				}

                // Start processing. 
                zw.controlLoop();

                return; // Don't return false here otherwise opera will not detect change of the mouse pointer type.
            });
        };
       

        img1 = new Image();
        $(img1).load(function () {
        	ctx.init2(this, 0);
            
        });
        img1.src = sImg.attr('src');

        img2 = new Image();
        $(img2).load(function () {
            ctx.init2(this, 1);
        });
        img2.src = jWin.attr('href');
    }

    $.fn.CloudZoom = function (options) {
       try {
            document.execCommand("BackgroundImageCache", false, true)
        } catch (e) {}
        this.each(function () {
            var relOpts, opts;
            if ($(this).is('.cloud-zoom')) {
            	
            	var img = $(this).find('img');
        
                $(this).css({
                    'position': 'relative',
                    'display': 'block',
                    'margin': '0 auto',
                    'text-align': 'center'
                });
                $('img', $(this)).css({
                    'display': 'block'
                });
                
                var img = $(this).find('img');
                
                if ($(this).parent().attr('id') != 'wrap') {
                    $(this).wrap('<div id="wrap" style="top:0px;z-index:9;position:relative;width:'+img.innerWidth()+'px;margin:0 auto"></div>')
                }
                opts = $.extend({}, $.fn.CloudZoom.defaults, options);
                opts = $.extend({}, opts, relOpts);
                $(this).data('zoom', new CloudZoom($(this), opts));
            } else if ($(this).is('.cloud-zoom-gallery')) {
				relOpts = {
					useZoom: 'zoom1',
					smallImage: $(this).attr('src')
				};
				if(!$(this).parent().attr('id')) {
					relOpts.smallImage = $(this).attr('rev');
				} else {
					relOpts.smallImage = $(this).attr('src');
				}
				opts = $.extend({}, relOpts, options);
				$(this).data('relOpts', opts);
				$(this).bind('click', $(this), function (event) {
					event.preventDefault();
					var data = event.data.data('relOpts');
					$('#' + data.useZoom).data('zoom').destroy();
					$('#' + data.useZoom).attr('href', event.data.attr('href'));
					$('#' + data.useZoom + ' img').attr('src', relOpts.smallImage);
					$('#' + event.data.data('relOpts').useZoom).CloudZoom();

					// change title
					$('#zoom1 img').attr('title', $(this).attr('title'));

					//fading picture
					if ($.browser.msie && parseInt($.browser.version) > 8) {
						$('#wrap').fadeTo(0,0.01).delay(200).fadeTo(200,1);
					}
					return false;
				});
			}
        });
        return this
    };
    $.fn.CloudZoom.defaults = {
        zoomWidth: 487,
        zoomHeight: 260,
        position: 'right',
        tint: false,
        tintOpacity: 0.5,
        lensOpacity: 0.5,
        softFocus: false,
        smoothMove: 3,
        showTitle: true,
        titleOpacity: 0.5,
        adjustX: 20,
        adjustY: -5
    }
})(jQuery);
